(ns uikit-hl.flex
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-flex*        true)
(def ^:dynamic *uk-flex-inline* nil)

(def ^:dynamic *uk-flex-left*    nil)
(def ^:dynamic *uk-flex-left-s*  nil)
(def ^:dynamic *uk-flex-left-m*  nil)
(def ^:dynamic *uk-flex-left-l*  nil)
(def ^:dynamic *uk-flex-left-xl* nil)

(def ^:dynamic *uk-flex-center*    nil)
(def ^:dynamic *uk-flex-center-s*  nil)
(def ^:dynamic *uk-flex-center-m*  nil)
(def ^:dynamic *uk-flex-center-l*  nil)
(def ^:dynamic *uk-flex-center-xl* nil)

(def ^:dynamic *uk-flex-right*    nil)
(def ^:dynamic *uk-flex-right-s*  nil)
(def ^:dynamic *uk-flex-right-m*  nil)
(def ^:dynamic *uk-flex-right-l*  nil)
(def ^:dynamic *uk-flex-right-xl* nil)

(def ^:dynamic *uk-flex-between*    nil)
(def ^:dynamic *uk-flex-between-s*  nil)
(def ^:dynamic *uk-flex-between-m*  nil)
(def ^:dynamic *uk-flex-between-l*  nil)
(def ^:dynamic *uk-flex-between-xl* nil)

(def ^:dynamic *uk-flex-around*    nil)
(def ^:dynamic *uk-flex-around-s*  nil)
(def ^:dynamic *uk-flex-around-m*  nil)
(def ^:dynamic *uk-flex-around-l*  nil)
(def ^:dynamic *uk-flex-around-xl* nil)

(def ^:dynamic *uk-flex-stretch* nil)
(def ^:dynamic *uk-flex-top*     nil)
(def ^:dynamic *uk-flex-middle*  nil)
(def ^:dynamic *uk-flex-bottom*  nil)

(defmethod hl/do! :uk-flex
  [elem _ v]
  (->> v
    (merge {:uk-flex        *uk-flex*
            :uk-flex-inline *uk-flex-inline*

            :uk-flex-left               *uk-flex-left*
            (keyword "uk-flex-left@s")  *uk-flex-left-s*
            (keyword "uk-flex-left@m")  *uk-flex-left-m*
            (keyword "uk-flex-left@l")  *uk-flex-left-l*
            (keyword "uk-flex-left@xl") *uk-flex-left-xl*

            :uk-flex-center               *uk-flex-center*
            (keyword "uk-flex-center@s")  *uk-flex-center-s*
            (keyword "uk-flex-center@m")  *uk-flex-center-m*
            (keyword "uk-flex-center@l")  *uk-flex-center-l*
            (keyword "uk-flex-center@xl") *uk-flex-center-xl*

            :uk-flex-right               *uk-flex-right*
            (keyword "uk-flex-right@s")  *uk-flex-right-s*
            (keyword "uk-flex-right@m")  *uk-flex-right-m*
            (keyword "uk-flex-right@l")  *uk-flex-right-l*
            (keyword "uk-flex-right@xl") *uk-flex-right-xl*

            :uk-flex-between               *uk-flex-between*
            (keyword "uk-flex-between@s")  *uk-flex-between-s*
            (keyword "uk-flex-between@m")  *uk-flex-between-m*
            (keyword "uk-flex-between@l")  *uk-flex-between-l*
            (keyword "uk-flex-between@xl") *uk-flex-between-xl*

            :uk-flex-around               *uk-flex-around*
            (keyword "uk-flex-around@s")  *uk-flex-around-s*
            (keyword "uk-flex-around@m")  *uk-flex-around-m*
            (keyword "uk-flex-around@l")  *uk-flex-around-l*
            (keyword "uk-flex-around@xl") *uk-flex-around-xl*

            :uk-flex-stretch *uk-flex-stretch*
            :uk-flex-top     *uk-flex-top*
            :uk-flex-middle  *uk-flex-middle*
            :uk-flex-bottom  *uk-flex-bottom*

            :uk-flex-row            *uk-flex-row*
            :uk-flex-row-reverse    *uk-flex-row-reverse*
            :uk-flex-column         *uk-flex-column*
            :uk-flex-column-reverse *uk-flex-column-reverse*
})
    (hl/do! elem :class )))
