(ns uikit-hl.core)

(def width-templates '("%s-%s" "%s-%s-s" "%s-%s-m" "%s-%s-l" "%s-%s-xl" ))

(defmacro defwidth [prefix width]
  (let [widths (map #(format (str "*" % "*") prefix width) width-templates)]
    `(do ~@(for [name (map #(-> % str symbol) widths)]
      `(def ^:dynamic ~name nil)))))

(defmacro defwidthmethod [prefix width]
  (let [widths (map #(format % prefix width) width-templates)]
    `(do ~@(for [name widths]
      `(defmethod hl/do! ~(keyword name)
        [elem# kw# v#]
        (hl/do! elem# ~(keyword (str "uk-" prefix))
          {~(keyword (str "uk-" (clojure.string/replace name #"-(\D)$" "@$1"))) v#}))))))
