(ns uikit-hl.core)

(def width-templates '("*%s-%s*" "*%s-%s-s*" "*%s-%s-m*" "*%s-%s-l*" "*%s-%s-xl*" ))
(def widthmethod-templates '("*%s-%s*" "*%s-%s@s*" "*%s-%s@m*" "*%s-%s@l*" "*%s-%s@xl*" ))

(defmacro defwidth [prefix width & [tpl]]
  (let [widths (map #(format % prefix width) (or '(tpl) width-templates)])
    `(do ~@(for [name (map #(-> % str symbol) widths)]
      `(def ^:dynamic ~name nil)))))

(defmacro defwidthmethod [prefix width & [tpl]]
  (let [widths (map #(format % prefix width) (or '(tpl) widthmethod-templates))]
    `(do ~@(for [name widths]
      `(defmethod hl/do! ~(keyword name)
        [elem _ v]
        (hl/do! elem ~(keyword (str "uk-" prefix)) {~(keyword (str "uk-" name)) v}))))))
