(ns uikit-hl.core)

(def width-templates '("*%s-%s*" "*%s-%s-s*" "*%s-%s-m*" "*%s-%s-l*" "*%s-%s-xl*" ))

;(def child-width-templates '("child-width-%s" "child-width-%s-small" "child-width-%s-medium" "child-width-%s-large" "child-width-%s-xlarge" ))

(defmacro defwidth [prefix width & [tpl]]
  (let [widths (map #(format % prefix width) (or '(tpl) width-templates)])
    `(do ~@(for [name (map #(-> % str symbol) widths)]
      `(def ^:dynamic ~name nil)))))

(defmacro defwidthmethod [prefix width & [tpl]]
  (let [widths (map #(format % prefix width) (or '(tpl) width-templates)])
    `(do ~@(for [name (map #(-> % str keyword) widths)]
      `(defmethod hl/do! ~name
        [elem _ v]
        (hl/do! elem :uk-width {:uk-width-1-1 v}))))))

;(defmacro defchildwidth [width]
;  (let [widths (map #(format % width) child-width-templates)]
;    `(do ~@(for [name (map #(-> % string keyword) widths)]
;      `(def ^:dynamic ~name nil)))))
