(ns uikit-hl.width
  (:require [uikit-hl.core :as core :include-macros true]
            [hoplon.core :as hl]))

(core/defwidth "width" "1-1")
(core/defwidth "width" "1-2")
(core/defwidth "width" "1-3")
(core/defwidth "width" "1-4")
(core/defwidth "width" "1-5")
(core/defwidth "width" "1-6")

(core/defwidth "width" "2-3")
(core/defwidth "width" "2-4")
(core/defwidth "width" "2-5")
(core/defwidth "width" "2-6")

(core/defwidth "width" "3-4")
(core/defwidth "width" "3-5")
(core/defwidth "width" "3-6")

(core/defwidth "width" "4-5")
(core/defwidth "width" "4-6")

(core/defwidth "width" "5-6")

(core/defwidth "width" "auto")
(core/defwidth "width" "expand")

(core/defwidth "child-width" "1-6")
(core/defwidth "child-width" "2-6")
(core/defwidth "child-width" "3-6")
(core/defwidth "child-width" "4-6")
(core/defwidth "child-width" "5-6")
(core/defwidth "child-width" "2-6")

(core/defwidth "child-width" "auto")
(core/defwidth "child-width" "expand")

(core/defwidth "width" "small" "%s-%s")
(core/defwidth "width" "medium" "%s-%s")
(core/defwidth "width" "large" "%s-%s")
(core/defwidth "width" "xlarge" "%s-%s")
(core/defwidth "width" "xxlarge" "%s-%s")

(defmethod hl/do! :uk-width
  [elem _ v]
  (->> v
    (merge {:uk-width-1-1               *width-1-1*
            (keyword "uk-width-1-1@s")  *width-1-1-s*
            (keyword "uk-width-1-1@m")  *width-1-1-m*
            (keyword "uk-width-1-1@l")  *width-1-1-l*
            (keyword "uk-width-1-1@xl") *width-1-1-xl*

            :uk-width-1-2               *width-1-2*
            (keyword "uk-width-1-2@s")  *width-1-2-s*
            (keyword "uk-width-1-2@m")  *width-1-2-m*
            (keyword "uk-width-1-2@l")  *width-1-2-l*
            (keyword "uk-width-1-2@xl") *width-1-2-xl*

            :uk-width-1-3               *width-1-3*
            (keyword "uk-width-1-3@s")  *width-1-3-s*
            (keyword "uk-width-1-3@m")  *width-1-3-m*
            (keyword "uk-width-1-3@l")  *width-1-3-l*
            (keyword "uk-width-1-3@xl") *width-1-3-xl*

            :uk-width-1-4               *width-1-4*
            (keyword "uk-width-1-4@s")  *width-1-4-s*
            (keyword "uk-width-1-4@m")  *width-1-4-m*
            (keyword "uk-width-1-4@l")  *width-1-4-l*
            (keyword "uk-width-1-4@xl") *width-1-4-xl*

            :uk-width-1-5               *width-1-5*
            (keyword "uk-width-1-5@s")  *width-1-5-s*
            (keyword "uk-width-1-5@m")  *width-1-5-m*
            (keyword "uk-width-1-5@l")  *width-1-5-l*
            (keyword "uk-width-1-5@xl") *width-1-5-xl*

            :uk-width-1-6               *width-1-6*
            (keyword "uk-width-1-6@s")  *width-1-6-s*
            (keyword "uk-width-1-6@m")  *width-1-6-m*
            (keyword "uk-width-1-6@l")  *width-1-6-l*
            (keyword "uk-width-1-6@xl") *width-1-6-xl*

            :uk-width-2-3               *width-2-3*
            (keyword "uk-width-2-3@s")  *width-2-3-s*
            (keyword "uk-width-2-3@m")  *width-2-3-m*
            (keyword "uk-width-2-3@l")  *width-2-3-l*
            (keyword "uk-width-2-3@xl") *width-2-3-xl*

            :uk-width-2-4               *width-2-4*
            (keyword "uk-width-2-4@s")  *width-2-4-s*
            (keyword "uk-width-2-4@m")  *width-2-4-m*
            (keyword "uk-width-2-4@l")  *width-2-4-l*
            (keyword "uk-width-2-4@xl") *width-2-4-xl*

            :uk-width-2-5               *width-2-5*
            (keyword "uk-width-2-5@s")  *width-2-5-s*
            (keyword "uk-width-2-5@m")  *width-2-5-m*
            (keyword "uk-width-2-5@l")  *width-2-5-l*
            (keyword "uk-width-2-5@xl") *width-2-5-xl*

            :uk-width-2-6               *width-2-6*
            (keyword "uk-width-2-6@s")  *width-2-6-s*
            (keyword "uk-width-2-6@m")  *width-2-6-m*
            (keyword "uk-width-2-6@l")  *width-2-6-l*
            (keyword "uk-width-2-6@xl") *width-2-6-xl*

            :uk-width-3-4               *width-3-4*
            (keyword "uk-width-3-4@s")  *width-3-4-s*
            (keyword "uk-width-3-4@m")  *width-3-4-m*
            (keyword "uk-width-3-4@l")  *width-3-4-l*
            (keyword "uk-width-3-4@xl") *width-3-4-xl*

            :uk-width-3-5               *width-3-5*
            (keyword "uk-width-3-5@s")  *width-3-5-s*
            (keyword "uk-width-3-5@m")  *width-3-5-m*
            (keyword "uk-width-3-5@l")  *width-3-5-l*
            (keyword "uk-width-3-5@xl") *width-3-5-xl*

            :uk-width-3-6               *width-3-6*
            (keyword "uk-width-3-6@s")  *width-3-6-s*
            (keyword "uk-width-3-6@m")  *width-3-6-m*
            (keyword "uk-width-3-6@l")  *width-3-6-l*
            (keyword "uk-width-3-6@xl") *width-3-6-xl*

            :uk-width-4-5               *width-4-5*
            (keyword "uk-width-4-5@s")  *width-4-5-s*
            (keyword "uk-width-4-5@m")  *width-4-5-m*
            (keyword "uk-width-4-5@l")  *width-4-5-l*
            (keyword "uk-width-4-5@xl") *width-4-5-xl*

            :uk-width-4-6               *width-4-6*
            (keyword "uk-width-4-6@s")  *width-4-6-s*
            (keyword "uk-width-4-6@m")  *width-4-6-m*
            (keyword "uk-width-4-6@l")  *width-4-6-l*
            (keyword "uk-width-4-6@xl") *width-4-6-xl*
        })
    (hl/do! elem :class )))

(defmethod hl/do! :width-fade
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-fade v}))

(defmethod hl/do! :width-scale-up
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-scale-up v}))

(defmethod hl/do! :width-scale-down
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-scale-down v}))

(defmethod hl/do! :width-slide-top
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-top v}))

(defmethod hl/do! :width-slide-bottom
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-bottom v}))

(defmethod hl/do! :width-slide-left
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-left v}))

(defmethod hl/do! :width-slide-right
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-right v}))

(defmethod hl/do! :width-slide-top-small
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-top-small v}))

(defmethod hl/do! :width-slide-bottom-small
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-bottom-small v}))

(defmethod hl/do! :width-slide-left-small
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-left-small v}))

(defmethod hl/do! :width-slide-right-small
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-right-small v}))

(defmethod hl/do! :width-slide-top-medium
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-top-medium v}))

(defmethod hl/do! :width-slide-bottom-medium
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-bottom-medium v}))

(defmethod hl/do! :width-slide-left-medium
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-left-medium v}))

(defmethod hl/do! :width-slide-right-medium
  [elem _ v]
  (hl/do! elem :uk-width {:uk-width-slide-right-medium v}))
