(ns uikit-hl.core)

(def width-templates '("*%s-%s*" "*%s-%s-small*" "*%s-%s-medium*" "*%s-%s-large*" "*%s-%s-xlarge*" ))

;(def child-width-templates '("child-width-%s" "child-width-%s-small" "child-width-%s-medium" "child-width-%s-large" "child-width-%s-xlarge" ))

(defmacro defwidth [prefix width & [tpl]]
  (let [widths (map #(format % prefix width) (or tpl width-templates)])
    `(do ~@(for [name (map #(-> % str symbol) widths)]
      `(def ^:dynamic ~name nil)))))

;(defmacro defchildwidth [width]
;  (let [widths (map #(format % width) child-width-templates)]
;    `(do ~@(for [name (map #(-> % string keyword) widths)]
;      `(def ^:dynamic ~name nil)))))
