(ns uikit-hl.core)

(def width-templates '("*width-%s*" "*width-%s-small*" "*width-%s-medium*" "*width-%s-large*" "*width-%s-xlarge*" ))

;(def child-width-templates '("child-width-%s" "child-width-%s-small" "child-width-%s-medium" "child-width-%s-large" "child-width-%s-xlarge" ))

(defmacro defwidth [width]
  (let [widths (map #(format % width) width-templates)]
    `(do ~@(for [name (map #(-> % str symbol) widths)]
      `(def ^:dynamic ~name nil)))))

;(defmacro defchildwidth [width]
;  (let [widths (map #(format % width) child-width-templates)]
;    `(do ~@(for [name (map #(-> % string keyword) widths)]
;      `(def ^:dynamic ~name nil)))))
