(ns meta.remote
  "Provides methods for connecting via microservices pattern."
  (:require
    ["@feathersjs/client" :as feathers]
    ["request" :as req]
    [feathers.client :as client]))

(defn request [app uri & opts]
  (configure app (.request (feathers/rest uri) (.defaults req opts))))

(defn connection
  "Create a connection to a remote server."
  ([uri] (connection uri {}))
  ([uri opts]
   (-> (client/app)
     (client/with-request uri opts))))

(defn service
  "Create a service which will proxy requests to a remote service."
  [service & [opts]]
  (let [uri (:uri opts)]
    (reify
      Object
      (id [this] "id")
      (setup [this app path]
        (goog.object/set this "remote"
          (client/service (connection uri) service)))
      (find [this params]
        (client/find (goog.object/get this "remote") params))
      (get [this id params]
        (client/get (goog.object/get this "remote") id params))
      (create [this data params]
        (client/create (goog.object/get this "remote") data params))
      (update [this id data params]
        (client/update (goog.object/get this "remote") id data params))
      (patch [this id data params]
        (client/patch (goog.object/get this "remote") id data params))
      (remove [this id params]
        (client/remove (goog.object/get this "remote") id params)))))

(defn api
  "Mount a remote service to a local endpoint."
  [app path uri hooks]
  (server/api app path (service path {:uri uri}) hooks))
