(ns meta.services.users
  (:require [feathers.app :as feathers]
            [meta.services :as services]
            [meta.services.hooks :as hooks]))

(def pre-hooks {:all    []
                :find   [(hooks/auth. #js["jwt" "local"])]
                :get    [(hooks/auth. #js["jwt" "local"])]
                :create [(hooks/hashpass.) (hooks/addVerification.)]
                :update [(hooks/disallow "external")]
                :patch  []
                :remove []})

(def post-hooks {:all    []
                 :find   []
                 :get    []
                 :create [(hooks/removeVerification.)]
                 :update []
                 :patch  []
                 :remove []})

(def user-hooks {:before pre-hooks :after post-hooks})

(defn users [app & [store]]
  (let [storef (or store services/memory)]
    (feathers/api app "users" (storef) user-hooks)))
