(ns meta.ui
  (:require [hoplon.core :as h]
            [meta.ui.mdc :as mdc]
            [meta.ui.uikit :as uikit]))

(defn app [& opts]
  (let [style (:style opts :uikit)]
    (case style
      :mdc (apply mdc/app opts)
      :uikit (apply uikit/app opts))))

;;; RAW DOM Elements ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def html h/html)
(def head h/head)
(def body h/body)

(def a              h/a)
(def abbr           h/abbr)
(def address        h/address)
(def area           h/area)
(def article        h/article)
(def aside          h/aside)
(def audio          h/audio)
(def b              h/b)
(def base           h/base)
(def bdi            h/bdi)
(def bdo            h/bdo)
(def blockquote     h/blockquote)
(def br             h/br)
(def button         h/button)
(def canvas         h/canvas)
(def caption        h/caption)
(def cite           h/cite)
(def code           h/code)
(def col            h/col)
(def colgroup       h/colgroup)
(def data           h/data)
(def datalist       h/datalist)
(def dd             h/dd)
(def del            h/del)
(def details        h/details)
(def dfn            h/dfn)
(def dialog         h/dialog)
(def div            h/div)
(def dl             h/dl)
(def dt             h/dt)
(def em             h/em)
(def embed          h/embed)
(def fieldset       h/fieldset)
(def figcaption     h/figcaption)
(def figure         h/figure)
(def footer         h/footer)
(def form           h/form)
(def h1             h/h1)
(def h2             h/h2)
(def h3             h/h3)
(def h4             h/h4)
(def h5             h/h5)
(def h6             h/h6)
(def header         h/header)
(def hgroup         h/hgroup)
(def hr             h/hr)
(def i              h/i)
(def iframe         h/iframe)
(def img            h/img)
(def input          h/input)
(def ins            h/ins)
(def kbd            h/kbd)
(def keygen         h/keygen)
(def label          h/label)
(def legend         h/legend)
(def li             h/li)
(def link           h/link)
(def main           h/main)
(def html-map       h/html-map)
(def mark           (make-elem-ctor "mark"))
(def menu           (make-elem-ctor "menu")) ;; experimental
(def menuitem       (make-elem-ctor "menuitem")) ;; experimental
(def html-meta      (make-elem-ctor "meta"))
(def meter          (make-elem-ctor "meter"))
(def multicol       (make-elem-ctor "multicol"))
(def nav            (make-elem-ctor "nav"))
(def noframes       (make-elem-ctor "noframes"))
(def noscript       (make-elem-ctor "noscript"))
(def html-object    (make-elem-ctor "object"))
(def ol             (make-elem-ctor "ol"))
(def optgroup       (make-elem-ctor "optgroup"))
(def option         (make-elem-ctor "option"))
(def output         (make-elem-ctor "output"))
(def p              (make-elem-ctor "p"))
(def param          (make-elem-ctor "param"))
(def picture        (make-elem-ctor "picture")) ;; experimental
(def pre            (make-elem-ctor "pre"))
(def progress       (make-elem-ctor "progress"))
(def q              (make-elem-ctor "q"))
(def rp             (make-elem-ctor "rp"))
(def rt             (make-elem-ctor "rt"))
(def rtc            (make-elem-ctor "rtc"))
(def ruby           (make-elem-ctor "ruby"))
(def s              (make-elem-ctor "s"))
(def samp           (make-elem-ctor "samp"))
(def script         (make-elem-ctor "script"))
(def section        (make-elem-ctor "section"))
(def select         (make-elem-ctor "select"))
(def shadow         (make-elem-ctor "shadow"))
(def small          (make-elem-ctor "small"))
(def source         (make-elem-ctor "source"))
(def span           (make-elem-ctor "span"))
(def strong         (make-elem-ctor "strong"))
(def style          (make-elem-ctor "style"))
(def sub            (make-elem-ctor "sub"))
(def summary        (make-elem-ctor "summary"))
(def sup            (make-elem-ctor "sup"))
(def table          (make-elem-ctor "table"))
(def tbody          (make-elem-ctor "tbody"))
(def td             (make-elem-ctor "td"))
(def template       (make-elem-ctor "template"))
(def textarea       (make-elem-ctor "textarea"))
(def tfoot          (make-elem-ctor "tfoot"))
(def th             (make-elem-ctor "th"))
(def thead          (make-elem-ctor "thead"))
(def html-time      (make-elem-ctor "time"))
(def title          (make-elem-ctor "title"))
(def tr             (make-elem-ctor "tr"))
(def track          (make-elem-ctor "track"))
(def u              (make-elem-ctor "u"))
(def ul             (make-elem-ctor "ul"))
(def html-var       (make-elem-ctor "var"))
(def video          (make-elem-ctor "video"))
(def wbr            (make-elem-ctor "wbr"))

(def spliced        vector)
(def $text          #(.createTextNode js/document %))
(def $comment       #(.createComment js/document %))

(def <!--           $comment)
(def -->            ::-->)
