(ns meta.nobackend.firebase
  (:require [firebase-cljs.core :as fb]
            [firebase-cljs.database :as fbdb]
            [firebase-cljs.database.query :as fbdq]
            [firebase-cljs.database.datasnapshot :as fbsnap]
            [firebase-cljs.user :as fbuser]
            [hoplon.firebase :as hfb]
            [hoplon.firebase.auth :as hfba]))

;; Firebase Root ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def ^:dynamic *firebase*
  (if hfb/FIREBASE_ENV
    (hfb/fb-ref [:_meta])
    (.error js/console "Firebase Environment has not been initialized!")))

;; Firebase Public References ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn users
  ([] (hfb/fb-ref *firebase* [:users]))
  ([korks] (fbdb/get-in (users) korks)))

(defn users=
  [] (hfb/fb-cell (users)))

;; Firebase Authentication ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def auth! #(hfba/fb-auth! (users) {:enabled true}))
