# Supporting Username + Email

If you want to support both username and email password via local authentication, it's actually pretty simple. Simply do this:

```js
const app = feathers();
app.configure(rest())
  .configure(socketio())
  .configure(hooks())
  .use(bodyParser.json())
  .use(bodyParser.urlencoded({ extended: true }))
  .configure(auth({ secret: 'supersecret' }))
  .configure(local({
    name: 'local',
    usernameField: 'email'
  }))
  .configure(local({
    name: 'local-username',
    usernameField: 'username'
  }))
  .configure(jwt())
  .use('/users', memory())
  .use('/', feathers.static(__dirname + '/public'));

app.service('authentication').hooks({
  before: {
    create: [
      // You can chain multiple strategies
      auth.hooks.authenticate(['jwt', 'local', 'local-username']),
      customizeJWTPayload()
    ],
    remove: [
      auth.hooks.authenticate('jwt')
    ]
  }
});
```

That's it that's all. Your user will be looked up by the `usernameField`.