// Compiled by ClojureScript 1.9.542 {}
goog.provide('hoplon.core');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('javelin.core');
goog.require('cljs.reader');
goog.require('clojure.string');



cljs.core.enable_console_print_BANG_.call(null);
/**
 * Is the application running in a prerendering container (eg. PhantomJS via
 *   the prerender task)?
 */
hoplon.core.prerendering_QMARK_ = (new goog.Uri(window.location.href)).getParameterValue("prerendering");
/**
 * This is an internal implementation detail, exposed for the convenience of
 *   the hoplon.core/static macro. Experimental.
 */
hoplon.core.static_elements = cljs.core.reduce.call(null,(function (p1__9242_SHARP_,p2__9243_SHARP_){
return cljs.core.assoc.call(null,p1__9242_SHARP_,p2__9243_SHARP_.getAttribute("static-id"),p2__9243_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,document.querySelector("[static-id]"));
/**
 * Public helper.
 *   Adds f as a watcher to ref and evaluates (f init @ref) once. The watcher
 *   f is a function of two arguments: the previous and next values. If init is
 *   not provided the default (nil) will be used.
 */
hoplon.core.do_watch = (function hoplon$core$do_watch(var_args){
var args9244 = [];
var len__8297__auto___9247 = arguments.length;
var i__8298__auto___9248 = (0);
while(true){
if((i__8298__auto___9248 < len__8297__auto___9247)){
args9244.push((arguments[i__8298__auto___9248]));

var G__9249 = (i__8298__auto___9248 + (1));
i__8298__auto___9248 = G__9249;
continue;
} else {
}
break;
}

var G__9246 = args9244.length;
switch (G__9246) {
case 2:
return hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9244.length)].join('')));

}
});

hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$2 = (function (ref,f){
return hoplon.core.do_watch.call(null,ref,null,f);
});

hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$3 = (function (ref,init,f){
var k = cljs.core.gensym.call(null);
f.call(null,init,cljs.core.deref.call(null,ref));

cljs.core.add_watch.call(null,ref,k,((function (k){
return (function (_,___$1,old,new$){
return f.call(null,old,new$);
});})(k))
);

return k;
});

hoplon.core.do_watch.cljs$lang$maxFixedArity = 3;

/**
 * Public helper.
 *   Experimental.
 */
hoplon.core.bust_cache = (function hoplon$core$bust_cache(path){
var vec__9257 = cljs.core.reverse.call(null,clojure.string.split.call(null,path,/\//));
var seq__9258 = cljs.core.seq.call(null,vec__9257);
var first__9259 = cljs.core.first.call(null,seq__9258);
var seq__9258__$1 = cljs.core.next.call(null,seq__9258);
var f = first__9259;
var more = seq__9258__$1;
var vec__9260 = clojure.string.split.call(null,f,/\./,(2));
var f1 = cljs.core.nth.call(null,vec__9260,(0),null);
var f2 = cljs.core.nth.call(null,vec__9260,(1),null);
return clojure.string.join.call(null,"/",cljs.core.reverse.call(null,cljs.core.conj.call(null,more,clojure.string.join.call(null,".",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(f1),cljs.core.str.cljs$core$IFn$_invoke$arity$1("."),cljs.core.str.cljs$core$IFn$_invoke$arity$1("81376b2fc54644508aaf685655b655d4")].join(''),f2], null)))));
});
/**
 * Public helper.
 *   Class normalization for attribute providers.
 */
hoplon.core.normalize_class = (function hoplon$core$normalize_class(kvs){
var __GT_map = (function (p1__9263_SHARP_){
return cljs.core.zipmap.call(null,p1__9263_SHARP_,cljs.core.repeat.call(null,true));
});
if(cljs.core.map_QMARK_.call(null,kvs)){
return kvs;
} else {
return __GT_map.call(null,((typeof kvs === 'string')?kvs.split(/\s+/):cljs.core.seq.call(null,kvs)));
}
});
hoplon.core.child_vec = (function hoplon$core$child_vec(this$){
var x = this$.childNodes;
var l = x.length;
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
while(true){
var or__7184__auto__ = (function (){var and__7172__auto__ = cljs.core._EQ_.call(null,i,l);
if(and__7172__auto__){
return cljs.core.persistent_BANG_.call(null,ret);
} else {
return and__7172__auto__;
}
})();
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
var G__9264 = (i + (1));
var G__9265 = cljs.core.conj_BANG_.call(null,ret,x.item(i));
i = G__9264;
ret = G__9265;
continue;
}
break;
}
});
hoplon.core.vflatten = (function hoplon$core$vflatten(var_args){
var args9266 = [];
var len__8297__auto___9269 = arguments.length;
var i__8298__auto___9270 = (0);
while(true){
if((i__8298__auto___9270 < len__8297__auto___9269)){
args9266.push((arguments[i__8298__auto___9270]));

var G__9271 = (i__8298__auto___9270 + (1));
i__8298__auto___9270 = G__9271;
continue;
} else {
}
break;
}

var G__9268 = args9266.length;
switch (G__9268) {
case 1:
return hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9266.length)].join('')));

}
});

hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$1 = (function (tree){
return cljs.core.persistent_BANG_.call(null,hoplon.core.vflatten.call(null,tree,cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY)));
});

hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$2 = (function (tree,ret){
var l = cljs.core.count.call(null,tree);
var i = (0);
while(true){
if(cljs.core._EQ_.call(null,i,l)){
return ret;
} else {
var x = cljs.core.nth.call(null,tree,i);
if(!(cljs.core.sequential_QMARK_.call(null,x))){
cljs.core.conj_BANG_.call(null,ret,x);
} else {
hoplon.core.vflatten.call(null,x,ret);
}

var G__9273 = (i + (1));
i = G__9273;
continue;
}
break;
}
});

hoplon.core.vflatten.cljs$lang$maxFixedArity = 2;


/**
 * @interface
 */
hoplon.core.INode = function(){};

hoplon.core.node = (function hoplon$core$node(this$){
if((!((this$ == null))) && (!((this$.hoplon$core$INode$node$arity$1 == null)))){
return this$.hoplon$core$INode$node$arity$1(this$);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core.node[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$);
} else {
var m__7853__auto____$1 = (hoplon.core.node["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"INode.node",this$);
}
}
}
});

(hoplon.core.INode["string"] = true);

(hoplon.core.node["string"] = (function (this$){
return hoplon.core.$text.call(null,this$);
}));
(hoplon.core.INode["number"] = true);

(hoplon.core.node["number"] = (function (this$){
return hoplon.core.$text.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$)].join(''));
}));
hoplon.core.__GT_node = (function hoplon$core$__GT_node(x){
if(((!((x == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.hoplon$core$INode$)))?true:(((!x.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.INode,x):false)):cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.INode,x))){
return hoplon.core.node.call(null,x);
} else {
return x;
}
});
hoplon.core.removeChild = Element.prototype.removeChild;
hoplon.core.appendChild = Element.prototype.appendChild;
hoplon.core.insertBefore = Element.prototype.insertBefore;
hoplon.core.replaceChild = Element.prototype.replaceChild;
hoplon.core.setAttribute = Element.prototype.setAttribute;
hoplon.core.merge_kids = (function hoplon$core$merge_kids(this$,_,new$){
var new$__$1 = cljs.core.mapv.call(null,hoplon.core.__GT_node,cljs.core.reduce.call(null,(function (p1__9277_SHARP_,p2__9276_SHARP_){
if((p2__9276_SHARP_ == null)){
return p1__9277_SHARP_;
} else {
return cljs.core.conj.call(null,p1__9277_SHARP_,p2__9276_SHARP_);
}
}),cljs.core.PersistentVector.EMPTY,hoplon.core.vflatten.call(null,new$)));
var new_QMARK_ = cljs.core.set.call(null,new$__$1);
var G__9304 = new$__$1;
var vec__9306 = G__9304;
var seq__9307 = cljs.core.seq.call(null,vec__9306);
var first__9308 = cljs.core.first.call(null,seq__9307);
var seq__9307__$1 = cljs.core.next.call(null,seq__9307);
var x = first__9308;
var xs = seq__9307__$1;
var G__9305 = hoplon.core.child_vec.call(null,this$);
var vec__9309 = G__9305;
var seq__9310 = cljs.core.seq.call(null,vec__9309);
var first__9311 = cljs.core.first.call(null,seq__9310);
var seq__9310__$1 = cljs.core.next.call(null,seq__9310);
var k = first__9311;
var ks = seq__9310__$1;
var kids = vec__9309;
var G__9304__$1 = G__9304;
var G__9305__$1 = G__9305;
while(true){
var vec__9312 = G__9304__$1;
var seq__9313 = cljs.core.seq.call(null,vec__9312);
var first__9314 = cljs.core.first.call(null,seq__9313);
var seq__9313__$1 = cljs.core.next.call(null,seq__9313);
var x__$1 = first__9314;
var xs__$1 = seq__9313__$1;
var vec__9315 = G__9305__$1;
var seq__9316 = cljs.core.seq.call(null,vec__9315);
var first__9317 = cljs.core.first.call(null,seq__9316);
var seq__9316__$1 = cljs.core.next.call(null,seq__9316);
var k__$1 = first__9317;
var ks__$1 = seq__9316__$1;
var kids__$1 = vec__9315;
if(cljs.core.truth_((function (){var or__7184__auto__ = x__$1;
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return k__$1;
}
})())){
var G__9318 = xs__$1;
var G__9319 = ((cljs.core._EQ_.call(null,x__$1,k__$1))?ks__$1:((cljs.core.not.call(null,k__$1))?(function (){var ks__$2 = ks__$1;
hoplon.core.appendChild.call(this$,x__$1);

return ks__$2;
})():((cljs.core.not.call(null,x__$1))?(function (){var ks__$2 = ks__$1;
if(cljs.core.truth_(new_QMARK_.call(null,k__$1))){
} else {
hoplon.core.removeChild.call(this$,k__$1);
}

return ks__$2;
})():(function (){var kids__$2 = kids__$1;
hoplon.core.insertBefore.call(this$,x__$1,k__$1);

return kids__$2;
})()
)));
G__9304__$1 = G__9318;
G__9305__$1 = G__9319;
continue;
} else {
return null;
}
break;
}
});
hoplon.core.ensure_kids_BANG_ = (function hoplon$core$ensure_kids_BANG_(this$){
var this$__$1 = this$;
if(cljs.core.truth_(this$__$1.hoplonKids)){
} else {
var kids_9320 = cljs.core.atom.call(null,hoplon.core.child_vec.call(null,this$__$1));
this$__$1.hoplonKids = kids_9320;

hoplon.core.do_watch.call(null,kids_9320,cljs.core.partial.call(null,hoplon.core.merge_kids,this$__$1));
}

return this$__$1;
});
hoplon.core.remove_all_kids_BANG_ = (function hoplon$core$remove_all_kids_BANG_(this$){
this$.hoplonKids = null;

return hoplon.core.merge_kids.call(null,this$,null,null);
});
/**
 * Returns true if elem is a native element. Native elements' children
 *   are not managed by Hoplon.
 */
hoplon.core.native_QMARK_ = (function hoplon$core$native_QMARK_(elem){
return ((elem instanceof Element)) && ((elem.hoplonKids == null));
});
/**
 * Returns true if elem is a managed element. Managed elements have
 *   their children managed by Hoplon.
 */
hoplon.core.managed_QMARK_ = (function hoplon$core$managed_QMARK_(elem){
return cljs.core.not.call(null,hoplon.core.native_QMARK_.call(null,elem));
});
/**
 * Appends `child` to `parent` for the case of `parent` being a
 *   managed element.
 */
hoplon.core.managed_append_child = (function hoplon$core$managed_append_child(parent,child,kidfn){
var child__$1 = child;
hoplon.core.ensure_kids_BANG_.call(null,parent);

var kids_9323 = kidfn.call(null,parent);
var i_9324 = cljs.core.count.call(null,cljs.core.deref.call(null,kids_9323));
if(cljs.core.truth_(javelin.core.cell_QMARK_.call(null,child__$1))){
hoplon.core.do_watch.call(null,child__$1,((function (kids_9323,i_9324,child__$1){
return (function (p1__9322_SHARP_,p2__9321_SHARP_){
return cljs.core.swap_BANG_.call(null,kids_9323,cljs.core.assoc,i_9324,p2__9321_SHARP_);
});})(kids_9323,i_9324,child__$1))
);
} else {
cljs.core.swap_BANG_.call(null,kids_9323,cljs.core.assoc,i_9324,child__$1);
}

return child__$1;
});
hoplon.core.set_appendChild_BANG_ = (function hoplon$core$set_appendChild_BANG_(this$,kidfn){
return this$.appendChild = (function (child){
var this$__$1 = this;
if(cljs.core.truth_(child.parentNode)){
child.parentNode.removeChild(child);
} else {
}

if(cljs.core.truth_((function (){var and__7172__auto__ = hoplon.core.native_QMARK_.call(null,this$__$1);
if(cljs.core.truth_(and__7172__auto__)){
return cljs.core.not.call(null,javelin.core.cell_QMARK_.call(null,child));
} else {
return and__7172__auto__;
}
})())){
return hoplon.core.appendChild.call(this$__$1,child);
} else {
if(cljs.core.truth_((function (){var and__7172__auto__ = hoplon.core.native_QMARK_.call(null,this$__$1);
if(cljs.core.truth_(and__7172__auto__)){
return javelin.core.cell_QMARK_.call(null,child);
} else {
return and__7172__auto__;
}
})())){
return hoplon.core.managed_append_child.call(null,this$__$1,child,kidfn);
} else {
if(cljs.core.truth_(hoplon.core.managed_QMARK_.call(null,this$__$1))){
return hoplon.core.managed_append_child.call(null,this$__$1,child,kidfn);
} else {
throw cljs.core.ex_info.call(null,"Unexpected child type",new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"reason","reason",-2070751759),new cljs.core.Keyword("hoplon.core","unexpected-child-type","hoplon.core/unexpected-child-type",1756641127),new cljs.core.Keyword(null,"child","child",623967545),child,new cljs.core.Keyword(null,"native?","native?",-1916990868),hoplon.core.native_QMARK_.call(null,child),new cljs.core.Keyword(null,"managed?","managed?",-1222195407),hoplon.core.managed_QMARK_.call(null,child),new cljs.core.Keyword(null,"this","this",-611633625),this$__$1], null));

}
}
}
});
});
hoplon.core.set_removeChild_BANG_ = (function hoplon$core$set_removeChild_BANG_(this$,kidfn){
return this$.removeChild = (function (x){
var this$__$1 = this;
var x__$1 = x;
hoplon.core.ensure_kids_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),((function (x__$1,this$__$1){
return (function (p1__9325_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,cljs.core.partial.call(null,cljs.core._EQ_,x__$1),p1__9325_SHARP_));
});})(x__$1,this$__$1))
);

return x__$1;
});
});
hoplon.core.set_insertBefore_BANG_ = (function hoplon$core$set_insertBefore_BANG_(this$,kidfn){
return this$.insertBefore = (function (x,y){
var this$__$1 = this;
var x__$1 = x;
hoplon.core.ensure_kids_BANG_.call(null,this$__$1);

if(cljs.core.not.call(null,y)){
cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),cljs.core.conj,x__$1);
} else {
if(cljs.core.not_EQ_.call(null,x__$1,y)){
cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),((function (x__$1,this$__$1){
return (function (p1__9326_SHARP_){
return cljs.core.vec.call(null,cljs.core.mapcat.call(null,((function (x__$1,this$__$1){
return (function (z){
if(cljs.core._EQ_.call(null,z,y)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x__$1,z], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [z], null);
}
});})(x__$1,this$__$1))
,p1__9326_SHARP_));
});})(x__$1,this$__$1))
);
} else {
}
}

return x__$1;
});
});
hoplon.core.set_replaceChild_BANG_ = (function hoplon$core$set_replaceChild_BANG_(this$,kidfn){
return this$.replaceChild = (function (x,y){
var this$__$1 = this;
var y__$1 = y;
hoplon.core.ensure_kids_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),((function (y__$1,this$__$1){
return (function (p1__9327_SHARP_){
return cljs.core.mapv.call(null,((function (y__$1,this$__$1){
return (function (z){
if(cljs.core._EQ_.call(null,z,y__$1)){
return x;
} else {
return z;
}
});})(y__$1,this$__$1))
,p1__9327_SHARP_);
});})(y__$1,this$__$1))
);

return y__$1;
});
});
hoplon.core.set_setAttribute_BANG_ = (function hoplon$core$set_setAttribute_BANG_(this$,attrfn){
return this$.setAttribute = (function (k,v){
var this$__$1 = this;
var _ = undefined;
var kk_9328 = cljs.core.keyword.call(null,k);
var attr_9329 = attrfn.call(null,this$__$1);
var has_QMARK__9330 = (function (){var and__7172__auto__ = attr_9329;
if(cljs.core.truth_(and__7172__auto__)){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,attr_9329),kk_9328);
} else {
return and__7172__auto__;
}
})();
if(cljs.core.truth_(has_QMARK__9330)){
cljs.core.swap_BANG_.call(null,attr_9329,cljs.core.assoc,kk_9328,v);
} else {
hoplon.core.setAttribute.call(this$__$1,k,v);
}

return _;
});
});
hoplon.core.set_appendChild_BANG_.call(null,Element.prototype,(function (p1__9331_SHARP_){
return p1__9331_SHARP_.hoplonKids;
}));
hoplon.core.set_removeChild_BANG_.call(null,Element.prototype,(function (p1__9332_SHARP_){
return p1__9332_SHARP_.hoplonKids;
}));
hoplon.core.set_insertBefore_BANG_.call(null,Element.prototype,(function (p1__9333_SHARP_){
return p1__9333_SHARP_.hoplonKids;
}));
hoplon.core.set_replaceChild_BANG_.call(null,Element.prototype,(function (p1__9334_SHARP_){
return p1__9334_SHARP_.hoplonKids;
}));

/**
 * @interface
 */
hoplon.core.ICustomElement = function(){};

hoplon.core._set_attributes_BANG_ = (function hoplon$core$_set_attributes_BANG_(this$,kvs){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_set_attributes_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_set_attributes_BANG_$arity$2(this$,kvs);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core._set_attributes_BANG_[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$,kvs);
} else {
var m__7853__auto____$1 = (hoplon.core._set_attributes_BANG_["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$,kvs);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-set-attributes!",this$);
}
}
}
});

hoplon.core._set_styles_BANG_ = (function hoplon$core$_set_styles_BANG_(this$,kvs){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_set_styles_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_set_styles_BANG_$arity$2(this$,kvs);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core._set_styles_BANG_[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$,kvs);
} else {
var m__7853__auto____$1 = (hoplon.core._set_styles_BANG_["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$,kvs);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-set-styles!",this$);
}
}
}
});

hoplon.core._append_child_BANG_ = (function hoplon$core$_append_child_BANG_(this$,child){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_append_child_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_append_child_BANG_$arity$2(this$,child);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core._append_child_BANG_[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$,child);
} else {
var m__7853__auto____$1 = (hoplon.core._append_child_BANG_["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$,child);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-append-child!",this$);
}
}
}
});

hoplon.core._remove_child_BANG_ = (function hoplon$core$_remove_child_BANG_(this$,child){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_remove_child_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_remove_child_BANG_$arity$2(this$,child);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core._remove_child_BANG_[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$,child);
} else {
var m__7853__auto____$1 = (hoplon.core._remove_child_BANG_["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$,child);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-remove-child!",this$);
}
}
}
});

hoplon.core._replace_child_BANG_ = (function hoplon$core$_replace_child_BANG_(this$,new$,existing){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_replace_child_BANG_$arity$3 == null)))){
return this$.hoplon$core$ICustomElement$_replace_child_BANG_$arity$3(this$,new$,existing);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core._replace_child_BANG_[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$,new$,existing);
} else {
var m__7853__auto____$1 = (hoplon.core._replace_child_BANG_["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$,new$,existing);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-replace-child!",this$);
}
}
}
});

hoplon.core._insert_before_BANG_ = (function hoplon$core$_insert_before_BANG_(this$,new$,existing){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_insert_before_BANG_$arity$3 == null)))){
return this$.hoplon$core$ICustomElement$_insert_before_BANG_$arity$3(this$,new$,existing);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core._insert_before_BANG_[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$,new$,existing);
} else {
var m__7853__auto____$1 = (hoplon.core._insert_before_BANG_["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$,new$,existing);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-insert-before!",this$);
}
}
}
});

hoplon.core.set_attributes_BANG_ = (function hoplon$core$set_attributes_BANG_(var_args){
var args9335 = [];
var len__8297__auto___9342 = arguments.length;
var i__8298__auto___9343 = (0);
while(true){
if((i__8298__auto___9343 < len__8297__auto___9342)){
args9335.push((arguments[i__8298__auto___9343]));

var G__9344 = (i__8298__auto___9343 + (1));
i__8298__auto___9343 = G__9344;
continue;
} else {
}
break;
}

var G__9341 = args9335.length;
switch (G__9341) {
case 2:
return hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8316__auto__ = (new cljs.core.IndexedSeq(args9335.slice((3)),(0),null));
return hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8316__auto__);

}
});

hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,kvs){
return hoplon.core._set_attributes_BANG_.call(null,this$,kvs);
});

hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (this$,k,v,kvs){
return hoplon.core.set_attributes_BANG_.call(null,this$,cljs.core.apply.call(null,cljs.core.hash_map,k,v,kvs));
});

hoplon.core.set_attributes_BANG_.cljs$lang$applyTo = (function (seq9336){
var G__9337 = cljs.core.first.call(null,seq9336);
var seq9336__$1 = cljs.core.next.call(null,seq9336);
var G__9338 = cljs.core.first.call(null,seq9336__$1);
var seq9336__$2 = cljs.core.next.call(null,seq9336__$1);
var G__9339 = cljs.core.first.call(null,seq9336__$2);
var seq9336__$3 = cljs.core.next.call(null,seq9336__$2);
return hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9337,G__9338,G__9339,seq9336__$3);
});

hoplon.core.set_attributes_BANG_.cljs$lang$maxFixedArity = (3);

hoplon.core.set_styles_BANG_ = (function hoplon$core$set_styles_BANG_(var_args){
var args9346 = [];
var len__8297__auto___9353 = arguments.length;
var i__8298__auto___9354 = (0);
while(true){
if((i__8298__auto___9354 < len__8297__auto___9353)){
args9346.push((arguments[i__8298__auto___9354]));

var G__9355 = (i__8298__auto___9354 + (1));
i__8298__auto___9354 = G__9355;
continue;
} else {
}
break;
}

var G__9352 = args9346.length;
switch (G__9352) {
case 2:
return hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8316__auto__ = (new cljs.core.IndexedSeq(args9346.slice((3)),(0),null));
return hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8316__auto__);

}
});

hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,kvs){
return hoplon.core._set_styles_BANG_.call(null,this$,kvs);
});

hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (this$,k,v,kvs){
return hoplon.core.set_styles_BANG_.call(null,this$,cljs.core.apply.call(null,cljs.core.hash_map,k,v,kvs));
});

hoplon.core.set_styles_BANG_.cljs$lang$applyTo = (function (seq9347){
var G__9348 = cljs.core.first.call(null,seq9347);
var seq9347__$1 = cljs.core.next.call(null,seq9347);
var G__9349 = cljs.core.first.call(null,seq9347__$1);
var seq9347__$2 = cljs.core.next.call(null,seq9347__$1);
var G__9350 = cljs.core.first.call(null,seq9347__$2);
var seq9347__$3 = cljs.core.next.call(null,seq9347__$2);
return hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9348,G__9349,G__9350,seq9347__$3);
});

hoplon.core.set_styles_BANG_.cljs$lang$maxFixedArity = (3);

hoplon.core.append_child_BANG_ = (function hoplon$core$append_child_BANG_(this$,child){
return hoplon.core._append_child_BANG_.call(null,this$,child);
});
hoplon.core.remove_child_BANG_ = (function hoplon$core$remove_child_BANG_(this$,child){
return hoplon.core._remove_child_BANG_.call(null,this$,child);
});
hoplon.core.replace_child_BANG_ = (function hoplon$core$replace_child_BANG_(this$,new$,existing){
return hoplon.core._replace_child_BANG_.call(null,this$,new$,existing);
});
hoplon.core.insert_before_BANG_ = (function hoplon$core$insert_before_BANG_(this$,new$,existing){
return hoplon.core._insert_before_BANG_.call(null,this$,new$,existing);
});

/**
 * @interface
 */
hoplon.core.ICustomAttribute = function(){};

hoplon.core._attr_BANG_ = (function hoplon$core$_attr_BANG_(this$,elem,value){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomAttribute$_attr_BANG_$arity$3 == null)))){
return this$.hoplon$core$ICustomAttribute$_attr_BANG_$arity$3(this$,elem,value);
} else {
var x__7852__auto__ = (((this$ == null))?null:this$);
var m__7853__auto__ = (hoplon.core._attr_BANG_[goog.typeOf(x__7852__auto__)]);
if(!((m__7853__auto__ == null))){
return m__7853__auto__.call(null,this$,elem,value);
} else {
var m__7853__auto____$1 = (hoplon.core._attr_BANG_["_"]);
if(!((m__7853__auto____$1 == null))){
return m__7853__auto____$1.call(null,this$,elem,value);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomAttribute.-attr!",this$);
}
}
}
});

hoplon.core.attribute_QMARK_ = (function hoplon$core$attribute_QMARK_(this$){
if(!((this$ == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === this$.hoplon$core$ICustomAttribute$))){
return true;
} else {
if((!this$.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.ICustomAttribute,this$);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.ICustomAttribute,this$);
}
});
cljs.core.Keyword.prototype.hoplon$core$ICustomAttribute$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.hoplon$core$ICustomAttribute$_attr_BANG_$arity$3 = (function (this$,elem,value){
var this$__$1 = this;
if(cljs.core.truth_(javelin.core.cell_QMARK_.call(null,value))){
return hoplon.core.do_watch.call(null,value,((function (this$__$1){
return (function (p1__9360_SHARP_,p2__9359_SHARP_){
return hoplon.core.do_BANG_.call(null,elem,this$__$1,p2__9359_SHARP_);
});})(this$__$1))
);
} else {
if(cljs.core.fn_QMARK_.call(null,value)){
return hoplon.core.on_BANG_.call(null,elem,this$__$1,value);
} else {
return hoplon.core.do_BANG_.call(null,elem,this$__$1,value);

}
}
});
hoplon.core.is_ie8 = cljs.core.not.call(null,goog.object.get(window,"Node"));
hoplon.core._head_STAR_ = ((!(hoplon.core.is_ie8))?(function (p1__9361_SHARP_){
return p1__9361_SHARP_.head;
}):(function (p1__9362_SHARP_){
return p1__9362_SHARP_.documentElement.firstChild;
}));
hoplon.core.vector_QMARK__STAR_ = ((!(hoplon.core.is_ie8))?cljs.core.vector_QMARK_:(function (p1__9363_SHARP_){
try{return cljs.core.vector_QMARK_.call(null,p1__9363_SHARP_);
}catch (e9364){if((e9364 instanceof Error)){
var _ = e9364;
return null;
} else {
throw e9364;

}
}}));
hoplon.core.seq_QMARK__STAR_ = ((!(hoplon.core.is_ie8))?cljs.core.seq_QMARK_:(function (p1__9365_SHARP_){
try{return cljs.core.seq_QMARK_.call(null,p1__9365_SHARP_);
}catch (e9366){if((e9366 instanceof Error)){
var _ = e9366;
return null;
} else {
throw e9366;

}
}}));
/**
 * Like cljs.core/nth but returns nil or not found if the index is outside the coll
 */
hoplon.core.safe_nth = (function hoplon$core$safe_nth(var_args){
var args9367 = [];
var len__8297__auto___9371 = arguments.length;
var i__8298__auto___9372 = (0);
while(true){
if((i__8298__auto___9372 < len__8297__auto___9371)){
args9367.push((arguments[i__8298__auto___9372]));

var G__9373 = (i__8298__auto___9372 + (1));
i__8298__auto___9372 = G__9373;
continue;
} else {
}
break;
}

var G__9369 = args9367.length;
switch (G__9369) {
case 2:
return hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9367.length)].join('')));

}
});

hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,index){
return hoplon.core.safe_nth.call(null,coll,index,null);
});

hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,index,not_found){
try{return cljs.core.nth.call(null,coll,index,not_found);
}catch (e9370){if((e9370 instanceof Error)){
var _ = e9370;
return not_found;
} else {
throw e9370;

}
}});

hoplon.core.safe_nth.cljs$lang$maxFixedArity = 3;

/**
 * Executes a fuction after a delay, if no delay is passed, 0 is used as a default.
 */
hoplon.core.timeout = (function hoplon$core$timeout(var_args){
var args9375 = [];
var len__8297__auto___9378 = arguments.length;
var i__8298__auto___9379 = (0);
while(true){
if((i__8298__auto___9379 < len__8297__auto___9378)){
args9375.push((arguments[i__8298__auto___9379]));

var G__9380 = (i__8298__auto___9379 + (1));
i__8298__auto___9379 = G__9380;
continue;
} else {
}
break;
}

var G__9377 = args9375.length;
switch (G__9377) {
case 1:
return hoplon.core.timeout.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hoplon.core.timeout.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9375.length)].join('')));

}
});

hoplon.core.timeout.cljs$core$IFn$_invoke$arity$1 = (function (f){
return hoplon.core.timeout.call(null,f,(0));
});

hoplon.core.timeout.cljs$core$IFn$_invoke$arity$2 = (function (f,t){
return window.setTimeout(f,t);
});

hoplon.core.timeout.cljs$lang$maxFixedArity = 2;

hoplon.core.when_dom = (function hoplon$core$when_dom(this$,f){
if(!((this$ instanceof Element))){
return setTimeout((function (){
return f.call(null);
}),(0));
} else {
var temp__4655__auto__ = goog.object.get(this$,"_hoplonWhenDom");
if(cljs.core.truth_(temp__4655__auto__)){
var v = temp__4655__auto__;
return v.push(f);
} else {
goog.object.set(this$,"_hoplonWhenDom",[f]);

return setTimeout(((function (temp__4655__auto__){
return (function (){
return ((function (temp__4655__auto__){
return (function hoplon$core$when_dom_$_doit(){
if(cljs.core.not.call(null,document.documentElement.contains(this$))){
return setTimeout(((function (temp__4655__auto__){
return (function (){
return hoplon$core$when_dom_$_doit.call(null);
});})(temp__4655__auto__))
,(20));
} else {
var seq__9394_9398 = cljs.core.seq.call(null,goog.object.get(this$,"_hoplonWhenDom"));
var chunk__9395_9399 = null;
var count__9396_9400 = (0);
var i__9397_9401 = (0);
while(true){
if((i__9397_9401 < count__9396_9400)){
var f_9402__$1 = cljs.core._nth.call(null,chunk__9395_9399,i__9397_9401);
f_9402__$1.call(null);

var G__9403 = seq__9394_9398;
var G__9404 = chunk__9395_9399;
var G__9405 = count__9396_9400;
var G__9406 = (i__9397_9401 + (1));
seq__9394_9398 = G__9403;
chunk__9395_9399 = G__9404;
count__9396_9400 = G__9405;
i__9397_9401 = G__9406;
continue;
} else {
var temp__4657__auto___9407 = cljs.core.seq.call(null,seq__9394_9398);
if(temp__4657__auto___9407){
var seq__9394_9408__$1 = temp__4657__auto___9407;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9394_9408__$1)){
var c__8003__auto___9409 = cljs.core.chunk_first.call(null,seq__9394_9408__$1);
var G__9410 = cljs.core.chunk_rest.call(null,seq__9394_9408__$1);
var G__9411 = c__8003__auto___9409;
var G__9412 = cljs.core.count.call(null,c__8003__auto___9409);
var G__9413 = (0);
seq__9394_9398 = G__9410;
chunk__9395_9399 = G__9411;
count__9396_9400 = G__9412;
i__9397_9401 = G__9413;
continue;
} else {
var f_9414__$1 = cljs.core.first.call(null,seq__9394_9408__$1);
f_9414__$1.call(null);

var G__9415 = cljs.core.next.call(null,seq__9394_9408__$1);
var G__9416 = null;
var G__9417 = (0);
var G__9418 = (0);
seq__9394_9398 = G__9415;
chunk__9395_9399 = G__9416;
count__9396_9400 = G__9417;
i__9397_9401 = G__9418;
continue;
}
} else {
}
}
break;
}

return goog.object.set(this$,"_hoplonWhenDom",null);
}
});})(temp__4655__auto__))
.call(null);
});})(temp__4655__auto__))
,(0));
}
}
});
hoplon.core.parse_args = (function hoplon$core$parse_args(args){
var attr = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
var kids = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
var G__9435 = args;
var vec__9436 = G__9435;
var seq__9437 = cljs.core.seq.call(null,vec__9436);
var first__9438 = cljs.core.first.call(null,seq__9437);
var seq__9437__$1 = cljs.core.next.call(null,seq__9437);
var arg = first__9438;
var args__$1 = seq__9437__$1;
var attr__$1 = attr;
var kids__$1 = kids;
var G__9435__$1 = G__9435;
while(true){
var attr__$2 = attr__$1;
var kids__$2 = kids__$1;
var vec__9439 = G__9435__$1;
var seq__9440 = cljs.core.seq.call(null,vec__9439);
var first__9441 = cljs.core.first.call(null,seq__9440);
var seq__9440__$1 = cljs.core.next.call(null,seq__9440);
var arg__$1 = first__9441;
var args__$2 = seq__9440__$1;
if(cljs.core.not.call(null,(function (){var or__7184__auto__ = arg__$1;
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return args__$2;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.persistent_BANG_.call(null,attr__$2),cljs.core.persistent_BANG_.call(null,kids__$2)], null);
} else {
if(cljs.core.map_QMARK_.call(null,arg__$1)){
var G__9442 = cljs.core.reduce_kv.call(null,((function (attr__$1,kids__$1,G__9435__$1,attr__$2,kids__$2,vec__9439,seq__9440,first__9441,seq__9440__$1,arg__$1,args__$2,attr,kids,G__9435,vec__9436,seq__9437,first__9438,seq__9437__$1,arg,args__$1){
return (function (p1__9419_SHARP_,p2__9420_SHARP_,p3__9421_SHARP_){
return cljs.core.assoc_BANG_.call(null,p1__9419_SHARP_,p2__9420_SHARP_,p3__9421_SHARP_);
});})(attr__$1,kids__$1,G__9435__$1,attr__$2,kids__$2,vec__9439,seq__9440,first__9441,seq__9440__$1,arg__$1,args__$2,attr,kids,G__9435,vec__9436,seq__9437,first__9438,seq__9437__$1,arg,args__$1))
,attr__$2,arg__$1);
var G__9443 = kids__$2;
var G__9444 = args__$2;
attr__$1 = G__9442;
kids__$1 = G__9443;
G__9435__$1 = G__9444;
continue;
} else {
if(cljs.core.truth_(hoplon.core.attribute_QMARK_.call(null,arg__$1))){
var G__9445 = cljs.core.assoc_BANG_.call(null,attr__$2,arg__$1,cljs.core.first.call(null,args__$2));
var G__9446 = kids__$2;
var G__9447 = cljs.core.rest.call(null,args__$2);
attr__$1 = G__9445;
kids__$1 = G__9446;
G__9435__$1 = G__9447;
continue;
} else {
if(cljs.core.truth_(hoplon.core.seq_QMARK__STAR_.call(null,arg__$1))){
var G__9448 = attr__$2;
var G__9449 = cljs.core.reduce.call(null,cljs.core.conj_BANG_,kids__$2,hoplon.core.vflatten.call(null,arg__$1));
var G__9450 = args__$2;
attr__$1 = G__9448;
kids__$1 = G__9449;
G__9435__$1 = G__9450;
continue;
} else {
if(cljs.core.truth_(hoplon.core.vector_QMARK__STAR_.call(null,arg__$1))){
var G__9451 = attr__$2;
var G__9452 = cljs.core.reduce.call(null,cljs.core.conj_BANG_,kids__$2,hoplon.core.vflatten.call(null,arg__$1));
var G__9453 = args__$2;
attr__$1 = G__9451;
kids__$1 = G__9452;
G__9435__$1 = G__9453;
continue;
} else {
var G__9454 = attr__$2;
var G__9455 = cljs.core.conj_BANG_.call(null,kids__$2,arg__$1);
var G__9456 = args__$2;
attr__$1 = G__9454;
kids__$1 = G__9455;
G__9435__$1 = G__9456;
continue;

}
}
}
}
}
break;
}
});
hoplon.core.add_attributes_BANG_ = (function hoplon$core$add_attributes_BANG_(this$,attr){
return cljs.core.reduce_kv.call(null,(function (p1__9458_SHARP_,p2__9457_SHARP_,p3__9459_SHARP_){
hoplon.core._attr_BANG_.call(null,p2__9457_SHARP_,p1__9458_SHARP_,p3__9459_SHARP_);

return p1__9458_SHARP_;
}),this$,attr);
});
hoplon.core.add_children_BANG_ = (function hoplon$core$add_children_BANG_(this$,p__9460){
var vec__9468 = p__9460;
var seq__9469 = cljs.core.seq.call(null,vec__9468);
var first__9470 = cljs.core.first.call(null,seq__9469);
var seq__9469__$1 = cljs.core.next.call(null,seq__9469);
var child_cell = first__9470;
var _ = seq__9469__$1;
var kids = vec__9468;
var this$__$1 = this$;
var seq__9471_9475 = cljs.core.seq.call(null,hoplon.core.vflatten.call(null,kids));
var chunk__9472_9476 = null;
var count__9473_9477 = (0);
var i__9474_9478 = (0);
while(true){
if((i__9474_9478 < count__9473_9477)){
var x_9479 = cljs.core._nth.call(null,chunk__9472_9476,i__9474_9478);
var temp__4657__auto___9480 = hoplon.core.__GT_node.call(null,x_9479);
if(cljs.core.truth_(temp__4657__auto___9480)){
var x_9481__$1 = temp__4657__auto___9480;
hoplon.core.append_child_BANG_.call(null,this$__$1,x_9481__$1);
} else {
}

var G__9482 = seq__9471_9475;
var G__9483 = chunk__9472_9476;
var G__9484 = count__9473_9477;
var G__9485 = (i__9474_9478 + (1));
seq__9471_9475 = G__9482;
chunk__9472_9476 = G__9483;
count__9473_9477 = G__9484;
i__9474_9478 = G__9485;
continue;
} else {
var temp__4657__auto___9486 = cljs.core.seq.call(null,seq__9471_9475);
if(temp__4657__auto___9486){
var seq__9471_9487__$1 = temp__4657__auto___9486;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9471_9487__$1)){
var c__8003__auto___9488 = cljs.core.chunk_first.call(null,seq__9471_9487__$1);
var G__9489 = cljs.core.chunk_rest.call(null,seq__9471_9487__$1);
var G__9490 = c__8003__auto___9488;
var G__9491 = cljs.core.count.call(null,c__8003__auto___9488);
var G__9492 = (0);
seq__9471_9475 = G__9489;
chunk__9472_9476 = G__9490;
count__9473_9477 = G__9491;
i__9474_9478 = G__9492;
continue;
} else {
var x_9493 = cljs.core.first.call(null,seq__9471_9487__$1);
var temp__4657__auto___9494__$1 = hoplon.core.__GT_node.call(null,x_9493);
if(cljs.core.truth_(temp__4657__auto___9494__$1)){
var x_9495__$1 = temp__4657__auto___9494__$1;
hoplon.core.append_child_BANG_.call(null,this$__$1,x_9495__$1);
} else {
}

var G__9496 = cljs.core.next.call(null,seq__9471_9487__$1);
var G__9497 = null;
var G__9498 = (0);
var G__9499 = (0);
seq__9471_9475 = G__9496;
chunk__9472_9476 = G__9497;
count__9473_9477 = G__9498;
i__9474_9478 = G__9499;
continue;
}
} else {
}
}
break;
}

return this$__$1;
});
Element.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

Element.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var this$__$1 = this;
return cljs.core.write_all.call(null,writer,"#<Element: ",this$__$1.tagName,">");
});

Element.prototype.cljs$core$IFn$ = cljs.core.PROTOCOL_SENTINEL;

Element.prototype.call = (function() { 
var G__9532__delegate = function (self__,args){
var self____$1 = this;
var this$ = self____$1;
var vec__9501 = hoplon.core.parse_args.call(null,args);
var attr = cljs.core.nth.call(null,vec__9501,(0),null);
var kids = cljs.core.nth.call(null,vec__9501,(1),null);
var G__9504 = this$;
hoplon.core.add_attributes_BANG_.call(null,G__9504,attr);

hoplon.core.add_children_BANG_.call(null,G__9504,kids);

return G__9504;
};
var G__9532 = function (self__,var_args){
var args = null;
if (arguments.length > 1) {
var G__9533__i = 0, G__9533__a = new Array(arguments.length -  1);
while (G__9533__i < G__9533__a.length) {G__9533__a[G__9533__i] = arguments[G__9533__i + 1]; ++G__9533__i;}
  args = new cljs.core.IndexedSeq(G__9533__a,0,null);
} 
return G__9532__delegate.call(this,self__,args);};
G__9532.cljs$lang$maxFixedArity = 1;
G__9532.cljs$lang$applyTo = (function (arglist__9534){
var self__ = cljs.core.first(arglist__9534);
var args = cljs.core.rest(arglist__9534);
return G__9532__delegate(self__,args);
});
G__9532.cljs$core$IFn$_invoke$arity$variadic = G__9532__delegate;
return G__9532;
})()
;

Element.prototype.apply = (function (self__,args9500){
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args9500)));
});

Element.prototype.cljs$core$IFn$_invoke$arity$2 = (function() { 
var G__9535__delegate = function (args){
var this$ = this;
var vec__9505 = hoplon.core.parse_args.call(null,args);
var attr = cljs.core.nth.call(null,vec__9505,(0),null);
var kids = cljs.core.nth.call(null,vec__9505,(1),null);
var G__9508 = this$;
hoplon.core.add_attributes_BANG_.call(null,G__9508,attr);

hoplon.core.add_children_BANG_.call(null,G__9508,kids);

return G__9508;
};
var G__9535 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9536__i = 0, G__9536__a = new Array(arguments.length -  0);
while (G__9536__i < G__9536__a.length) {G__9536__a[G__9536__i] = arguments[G__9536__i + 0]; ++G__9536__i;}
  args = new cljs.core.IndexedSeq(G__9536__a,0,null);
} 
return G__9535__delegate.call(this,args);};
G__9535.cljs$lang$maxFixedArity = 0;
G__9535.cljs$lang$applyTo = (function (arglist__9537){
var args = cljs.core.seq(arglist__9537);
return G__9535__delegate(args);
});
G__9535.cljs$core$IFn$_invoke$arity$variadic = G__9535__delegate;
return G__9535;
})()
;

Element.prototype.hoplon$core$ICustomElement$ = cljs.core.PROTOCOL_SENTINEL;

Element.prototype.hoplon$core$ICustomElement$_set_attributes_BANG_$arity$2 = (function (this$,kvs){
var this$__$1 = this;
var e = this$__$1;
var seq__9509 = cljs.core.seq.call(null,kvs);
var chunk__9511 = null;
var count__9512 = (0);
var i__9513 = (0);
while(true){
if((i__9513 < count__9512)){
var vec__9515 = cljs.core._nth.call(null,chunk__9511,i__9513);
var k = cljs.core.nth.call(null,vec__9515,(0),null);
var v = cljs.core.nth.call(null,vec__9515,(1),null);
var k_9538__$1 = cljs.core.name.call(null,k);
if(cljs.core._EQ_.call(null,false,v)){
e.removeAttribute(k_9538__$1);
} else {
e.setAttribute(k_9538__$1,((cljs.core._EQ_.call(null,true,v))?k_9538__$1:v));
}

var G__9539 = seq__9509;
var G__9540 = chunk__9511;
var G__9541 = count__9512;
var G__9542 = (i__9513 + (1));
seq__9509 = G__9539;
chunk__9511 = G__9540;
count__9512 = G__9541;
i__9513 = G__9542;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9509);
if(temp__4657__auto__){
var seq__9509__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9509__$1)){
var c__8003__auto__ = cljs.core.chunk_first.call(null,seq__9509__$1);
var G__9543 = cljs.core.chunk_rest.call(null,seq__9509__$1);
var G__9544 = c__8003__auto__;
var G__9545 = cljs.core.count.call(null,c__8003__auto__);
var G__9546 = (0);
seq__9509 = G__9543;
chunk__9511 = G__9544;
count__9512 = G__9545;
i__9513 = G__9546;
continue;
} else {
var vec__9518 = cljs.core.first.call(null,seq__9509__$1);
var k = cljs.core.nth.call(null,vec__9518,(0),null);
var v = cljs.core.nth.call(null,vec__9518,(1),null);
var k_9547__$1 = cljs.core.name.call(null,k);
if(cljs.core._EQ_.call(null,false,v)){
e.removeAttribute(k_9547__$1);
} else {
e.setAttribute(k_9547__$1,((cljs.core._EQ_.call(null,true,v))?k_9547__$1:v));
}

var G__9548 = cljs.core.next.call(null,seq__9509__$1);
var G__9549 = null;
var G__9550 = (0);
var G__9551 = (0);
seq__9509 = G__9548;
chunk__9511 = G__9549;
count__9512 = G__9550;
i__9513 = G__9551;
continue;
}
} else {
return null;
}
}
break;
}
});

Element.prototype.hoplon$core$ICustomElement$_set_styles_BANG_$arity$2 = (function (this$,kvs){
var this$__$1 = this;
var e = this$__$1;
var seq__9521 = cljs.core.seq.call(null,kvs);
var chunk__9522 = null;
var count__9523 = (0);
var i__9524 = (0);
while(true){
if((i__9524 < count__9523)){
var vec__9525 = cljs.core._nth.call(null,chunk__9522,i__9524);
var k = cljs.core.nth.call(null,vec__9525,(0),null);
var v = cljs.core.nth.call(null,vec__9525,(1),null);
goog.object.set(e.style,cljs.core.name.call(null,k),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join(''));

var G__9552 = seq__9521;
var G__9553 = chunk__9522;
var G__9554 = count__9523;
var G__9555 = (i__9524 + (1));
seq__9521 = G__9552;
chunk__9522 = G__9553;
count__9523 = G__9554;
i__9524 = G__9555;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9521);
if(temp__4657__auto__){
var seq__9521__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9521__$1)){
var c__8003__auto__ = cljs.core.chunk_first.call(null,seq__9521__$1);
var G__9556 = cljs.core.chunk_rest.call(null,seq__9521__$1);
var G__9557 = c__8003__auto__;
var G__9558 = cljs.core.count.call(null,c__8003__auto__);
var G__9559 = (0);
seq__9521 = G__9556;
chunk__9522 = G__9557;
count__9523 = G__9558;
i__9524 = G__9559;
continue;
} else {
var vec__9528 = cljs.core.first.call(null,seq__9521__$1);
var k = cljs.core.nth.call(null,vec__9528,(0),null);
var v = cljs.core.nth.call(null,vec__9528,(1),null);
goog.object.set(e.style,cljs.core.name.call(null,k),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join(''));

var G__9560 = cljs.core.next.call(null,seq__9521__$1);
var G__9561 = null;
var G__9562 = (0);
var G__9563 = (0);
seq__9521 = G__9560;
chunk__9522 = G__9561;
count__9523 = G__9562;
i__9524 = G__9563;
continue;
}
} else {
return null;
}
}
break;
}
});

Element.prototype.hoplon$core$ICustomElement$_append_child_BANG_$arity$2 = (function (this$,child){
var this$__$1 = this;
if(!(hoplon.core.is_ie8)){
return this$__$1.appendChild(child);
} else {
try{return this$__$1.appendChild(child);
}catch (e9531){if((e9531 instanceof Error)){
var _ = e9531;
return null;
} else {
throw e9531;

}
}}
});

Element.prototype.hoplon$core$ICustomElement$_remove_child_BANG_$arity$2 = (function (this$,child){
var this$__$1 = this;
return this$__$1.removeChild(child);
});

Element.prototype.hoplon$core$ICustomElement$_replace_child_BANG_$arity$3 = (function (this$,new$,existing){
var this$__$1 = this;
return this$__$1.replaceChild(new$,existing);
});

Element.prototype.hoplon$core$ICustomElement$_insert_before_BANG_$arity$3 = (function (this$,new$,existing){
var this$__$1 = this;
return this$__$1.insertBefore(new$,existing);
});
hoplon.core.make_singleton_ctor = (function hoplon$core$make_singleton_ctor(elem){
return (function() { 
var G__9570__delegate = function (args){
var vec__9567 = hoplon.core.parse_args.call(null,args);
var attrs = cljs.core.nth.call(null,vec__9567,(0),null);
var kids = cljs.core.nth.call(null,vec__9567,(1),null);
hoplon.core.add_attributes_BANG_.call(null,elem,attrs);

if(cljs.core.not.call(null,new cljs.core.Keyword(null,"static","static",1214358571).cljs$core$IFn$_invoke$arity$1(attrs))){
hoplon.core.remove_all_kids_BANG_.call(null,elem);

return hoplon.core.add_children_BANG_.call(null,elem,kids);
} else {
return null;
}
};
var G__9570 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9571__i = 0, G__9571__a = new Array(arguments.length -  0);
while (G__9571__i < G__9571__a.length) {G__9571__a[G__9571__i] = arguments[G__9571__i + 0]; ++G__9571__i;}
  args = new cljs.core.IndexedSeq(G__9571__a,0,null);
} 
return G__9570__delegate.call(this,args);};
G__9570.cljs$lang$maxFixedArity = 0;
G__9570.cljs$lang$applyTo = (function (arglist__9572){
var args = cljs.core.seq(arglist__9572);
return G__9570__delegate(args);
});
G__9570.cljs$core$IFn$_invoke$arity$variadic = G__9570__delegate;
return G__9570;
})()
;
});
hoplon.core.make_elem_ctor = (function hoplon$core$make_elem_ctor(tag){
var mkelem = (function() { 
var G__9576__delegate = function (rest__9573_SHARP_){
return cljs.core.apply.call(null,document.createElement(tag),rest__9573_SHARP_);
};
var G__9576 = function (var_args){
var rest__9573_SHARP_ = null;
if (arguments.length > 0) {
var G__9577__i = 0, G__9577__a = new Array(arguments.length -  0);
while (G__9577__i < G__9577__a.length) {G__9577__a[G__9577__i] = arguments[G__9577__i + 0]; ++G__9577__i;}
  rest__9573_SHARP_ = new cljs.core.IndexedSeq(G__9577__a,0,null);
} 
return G__9576__delegate.call(this,rest__9573_SHARP_);};
G__9576.cljs$lang$maxFixedArity = 0;
G__9576.cljs$lang$applyTo = (function (arglist__9578){
var rest__9573_SHARP_ = cljs.core.seq(arglist__9578);
return G__9576__delegate(rest__9573_SHARP_);
});
G__9576.cljs$core$IFn$_invoke$arity$variadic = G__9576__delegate;
return G__9576;
})()
;
if(!(hoplon.core.is_ie8)){
return mkelem;
} else {
return ((function (mkelem){
return (function() { 
var G__9579__delegate = function (args){
try{return cljs.core.apply.call(null,mkelem,args);
}catch (e9575){if((e9575 instanceof Error)){
var _ = e9575;
return cljs.core.apply.call(null,hoplon.core.make_elem_ctor.call(null,"div"),args);
} else {
throw e9575;

}
}};
var G__9579 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9580__i = 0, G__9580__a = new Array(arguments.length -  0);
while (G__9580__i < G__9580__a.length) {G__9580__a[G__9580__i] = arguments[G__9580__i + 0]; ++G__9580__i;}
  args = new cljs.core.IndexedSeq(G__9580__a,0,null);
} 
return G__9579__delegate.call(this,args);};
G__9579.cljs$lang$maxFixedArity = 0;
G__9579.cljs$lang$applyTo = (function (arglist__9581){
var args = cljs.core.seq(arglist__9581);
return G__9579__delegate(args);
});
G__9579.cljs$core$IFn$_invoke$arity$variadic = G__9579__delegate;
return G__9579;
})()
;
;})(mkelem))
}
});
hoplon.core.html = (function hoplon$core$html(var_args){
var args__8304__auto__ = [];
var len__8297__auto___9583 = arguments.length;
var i__8298__auto___9584 = (0);
while(true){
if((i__8298__auto___9584 < len__8297__auto___9583)){
args__8304__auto__.push((arguments[i__8298__auto___9584]));

var G__9585 = (i__8298__auto___9584 + (1));
i__8298__auto___9584 = G__9585;
continue;
} else {
}
break;
}

var argseq__8305__auto__ = ((((0) < args__8304__auto__.length))?(new cljs.core.IndexedSeq(args__8304__auto__.slice((0)),(0),null)):null);
return hoplon.core.html.cljs$core$IFn$_invoke$arity$variadic(argseq__8305__auto__);
});

hoplon.core.html.cljs$core$IFn$_invoke$arity$variadic = (function (args){

return hoplon.core.add_attributes_BANG_.call(null,document.documentElement,cljs.core.nth.call(null,hoplon.core.parse_args.call(null,args),(0)));
});

hoplon.core.html.cljs$lang$maxFixedArity = (0);

hoplon.core.html.cljs$lang$applyTo = (function (seq9582){
return hoplon.core.html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq9582));
});

/**
 * Updates the document's `head` element in place.
 */
hoplon.core.head = hoplon.core.make_singleton_ctor.call(null,hoplon.core._head_STAR_.call(null,document));
/**
 * Updates the document's `body` element in place.
 */
hoplon.core.body = hoplon.core.make_singleton_ctor.call(null,document.body);
hoplon.core.a = hoplon.core.make_elem_ctor.call(null,"a");
hoplon.core.abbr = hoplon.core.make_elem_ctor.call(null,"abbr");
hoplon.core.address = hoplon.core.make_elem_ctor.call(null,"address");
hoplon.core.area = hoplon.core.make_elem_ctor.call(null,"area");
hoplon.core.article = hoplon.core.make_elem_ctor.call(null,"article");
hoplon.core.aside = hoplon.core.make_elem_ctor.call(null,"aside");
hoplon.core.audio = hoplon.core.make_elem_ctor.call(null,"audio");
hoplon.core.b = hoplon.core.make_elem_ctor.call(null,"b");
hoplon.core.base = hoplon.core.make_elem_ctor.call(null,"base");
hoplon.core.bdi = hoplon.core.make_elem_ctor.call(null,"bdi");
hoplon.core.bdo = hoplon.core.make_elem_ctor.call(null,"bdo");
hoplon.core.blockquote = hoplon.core.make_elem_ctor.call(null,"blockquote");
hoplon.core.br = hoplon.core.make_elem_ctor.call(null,"br");
hoplon.core.button = hoplon.core.make_elem_ctor.call(null,"button");
hoplon.core.canvas = hoplon.core.make_elem_ctor.call(null,"canvas");
hoplon.core.caption = hoplon.core.make_elem_ctor.call(null,"caption");
hoplon.core.cite = hoplon.core.make_elem_ctor.call(null,"cite");
hoplon.core.code = hoplon.core.make_elem_ctor.call(null,"code");
hoplon.core.col = hoplon.core.make_elem_ctor.call(null,"col");
hoplon.core.colgroup = hoplon.core.make_elem_ctor.call(null,"colgroup");
hoplon.core.data = hoplon.core.make_elem_ctor.call(null,"data");
hoplon.core.datalist = hoplon.core.make_elem_ctor.call(null,"datalist");
hoplon.core.dd = hoplon.core.make_elem_ctor.call(null,"dd");
hoplon.core.del = hoplon.core.make_elem_ctor.call(null,"del");
hoplon.core.details = hoplon.core.make_elem_ctor.call(null,"details");
hoplon.core.dfn = hoplon.core.make_elem_ctor.call(null,"dfn");
hoplon.core.dialog = hoplon.core.make_elem_ctor.call(null,"dialog");
hoplon.core.div = hoplon.core.make_elem_ctor.call(null,"div");
hoplon.core.dl = hoplon.core.make_elem_ctor.call(null,"dl");
hoplon.core.dt = hoplon.core.make_elem_ctor.call(null,"dt");
hoplon.core.em = hoplon.core.make_elem_ctor.call(null,"em");
hoplon.core.embed = hoplon.core.make_elem_ctor.call(null,"embed");
hoplon.core.fieldset = hoplon.core.make_elem_ctor.call(null,"fieldset");
hoplon.core.figcaption = hoplon.core.make_elem_ctor.call(null,"figcaption");
hoplon.core.figure = hoplon.core.make_elem_ctor.call(null,"figure");
hoplon.core.footer = hoplon.core.make_elem_ctor.call(null,"footer");
hoplon.core.form = hoplon.core.make_elem_ctor.call(null,"form");
hoplon.core.h1 = hoplon.core.make_elem_ctor.call(null,"h1");
hoplon.core.h2 = hoplon.core.make_elem_ctor.call(null,"h2");
hoplon.core.h3 = hoplon.core.make_elem_ctor.call(null,"h3");
hoplon.core.h4 = hoplon.core.make_elem_ctor.call(null,"h4");
hoplon.core.h5 = hoplon.core.make_elem_ctor.call(null,"h5");
hoplon.core.h6 = hoplon.core.make_elem_ctor.call(null,"h6");
hoplon.core.header = hoplon.core.make_elem_ctor.call(null,"header");
hoplon.core.hgroup = hoplon.core.make_elem_ctor.call(null,"hgroup");
hoplon.core.hr = hoplon.core.make_elem_ctor.call(null,"hr");
hoplon.core.i = hoplon.core.make_elem_ctor.call(null,"i");
hoplon.core.iframe = hoplon.core.make_elem_ctor.call(null,"iframe");
hoplon.core.img = hoplon.core.make_elem_ctor.call(null,"img");
hoplon.core.input = hoplon.core.make_elem_ctor.call(null,"input");
hoplon.core.ins = hoplon.core.make_elem_ctor.call(null,"ins");
hoplon.core.kbd = hoplon.core.make_elem_ctor.call(null,"kbd");
hoplon.core.keygen = hoplon.core.make_elem_ctor.call(null,"keygen");
hoplon.core.label = hoplon.core.make_elem_ctor.call(null,"label");
hoplon.core.legend = hoplon.core.make_elem_ctor.call(null,"legend");
hoplon.core.li = hoplon.core.make_elem_ctor.call(null,"li");
hoplon.core.link = hoplon.core.make_elem_ctor.call(null,"link");
hoplon.core.main = hoplon.core.make_elem_ctor.call(null,"main");
hoplon.core.html_map = hoplon.core.make_elem_ctor.call(null,"map");
hoplon.core.mark = hoplon.core.make_elem_ctor.call(null,"mark");
hoplon.core.menu = hoplon.core.make_elem_ctor.call(null,"menu");
hoplon.core.menuitem = hoplon.core.make_elem_ctor.call(null,"menuitem");
hoplon.core.html_meta = hoplon.core.make_elem_ctor.call(null,"meta");
hoplon.core.meter = hoplon.core.make_elem_ctor.call(null,"meter");
hoplon.core.multicol = hoplon.core.make_elem_ctor.call(null,"multicol");
hoplon.core.nav = hoplon.core.make_elem_ctor.call(null,"nav");
hoplon.core.noframes = hoplon.core.make_elem_ctor.call(null,"noframes");
hoplon.core.noscript = hoplon.core.make_elem_ctor.call(null,"noscript");
hoplon.core.html_object = hoplon.core.make_elem_ctor.call(null,"object");
hoplon.core.ol = hoplon.core.make_elem_ctor.call(null,"ol");
hoplon.core.optgroup = hoplon.core.make_elem_ctor.call(null,"optgroup");
hoplon.core.option = hoplon.core.make_elem_ctor.call(null,"option");
hoplon.core.output = hoplon.core.make_elem_ctor.call(null,"output");
hoplon.core.p = hoplon.core.make_elem_ctor.call(null,"p");
hoplon.core.param = hoplon.core.make_elem_ctor.call(null,"param");
hoplon.core.picture = hoplon.core.make_elem_ctor.call(null,"picture");
hoplon.core.pre = hoplon.core.make_elem_ctor.call(null,"pre");
hoplon.core.progress = hoplon.core.make_elem_ctor.call(null,"progress");
hoplon.core.q = hoplon.core.make_elem_ctor.call(null,"q");
hoplon.core.rp = hoplon.core.make_elem_ctor.call(null,"rp");
hoplon.core.rt = hoplon.core.make_elem_ctor.call(null,"rt");
hoplon.core.rtc = hoplon.core.make_elem_ctor.call(null,"rtc");
hoplon.core.ruby = hoplon.core.make_elem_ctor.call(null,"ruby");
hoplon.core.s = hoplon.core.make_elem_ctor.call(null,"s");
hoplon.core.samp = hoplon.core.make_elem_ctor.call(null,"samp");
hoplon.core.script = hoplon.core.make_elem_ctor.call(null,"script");
hoplon.core.section = hoplon.core.make_elem_ctor.call(null,"section");
hoplon.core.select = hoplon.core.make_elem_ctor.call(null,"select");
hoplon.core.shadow = hoplon.core.make_elem_ctor.call(null,"shadow");
hoplon.core.small = hoplon.core.make_elem_ctor.call(null,"small");
hoplon.core.source = hoplon.core.make_elem_ctor.call(null,"source");
hoplon.core.span = hoplon.core.make_elem_ctor.call(null,"span");
hoplon.core.strong = hoplon.core.make_elem_ctor.call(null,"strong");
hoplon.core.style = hoplon.core.make_elem_ctor.call(null,"style");
hoplon.core.sub = hoplon.core.make_elem_ctor.call(null,"sub");
hoplon.core.summary = hoplon.core.make_elem_ctor.call(null,"summary");
hoplon.core.sup = hoplon.core.make_elem_ctor.call(null,"sup");
hoplon.core.table = hoplon.core.make_elem_ctor.call(null,"table");
hoplon.core.tbody = hoplon.core.make_elem_ctor.call(null,"tbody");
hoplon.core.td = hoplon.core.make_elem_ctor.call(null,"td");
hoplon.core.template = hoplon.core.make_elem_ctor.call(null,"template");
hoplon.core.textarea = hoplon.core.make_elem_ctor.call(null,"textarea");
hoplon.core.tfoot = hoplon.core.make_elem_ctor.call(null,"tfoot");
hoplon.core.th = hoplon.core.make_elem_ctor.call(null,"th");
hoplon.core.thead = hoplon.core.make_elem_ctor.call(null,"thead");
hoplon.core.html_time = hoplon.core.make_elem_ctor.call(null,"time");
hoplon.core.title = hoplon.core.make_elem_ctor.call(null,"title");
hoplon.core.tr = hoplon.core.make_elem_ctor.call(null,"tr");
hoplon.core.track = hoplon.core.make_elem_ctor.call(null,"track");
hoplon.core.u = hoplon.core.make_elem_ctor.call(null,"u");
hoplon.core.ul = hoplon.core.make_elem_ctor.call(null,"ul");
hoplon.core.html_var = hoplon.core.make_elem_ctor.call(null,"var");
hoplon.core.video = hoplon.core.make_elem_ctor.call(null,"video");
hoplon.core.wbr = hoplon.core.make_elem_ctor.call(null,"wbr");
hoplon.core.spliced = cljs.core.vector;
hoplon.core.$text = (function hoplon$core$$text(p1__9586_SHARP_){
return document.createTextNode(p1__9586_SHARP_);
});
hoplon.core.$comment = (function hoplon$core$$comment(p1__9587_SHARP_){
return document.createComment(p1__9587_SHARP_);
});
hoplon.core._LT__BANG___ = hoplon.core.$comment;
hoplon.core.___GT_ = new cljs.core.Keyword("hoplon.core","-->","hoplon.core/-->",1031510657);
hoplon.core.add_initfn_BANG_ = (function hoplon$core$add_initfn_BANG_(f){
return window.addEventListener("load",(function (){
return setTimeout((function (){
return f.call(null);
}),(0));
}));
});
hoplon.core.page_load = (function hoplon$core$page_load(){
return document.dispatchEvent("page-load");
});
hoplon.core.on_page_load = (function hoplon$core$on_page_load(f){
return document.addEventListener("page-load",f);
});
hoplon.core.add_initfn_BANG_.call(null,(function (){
return document.body.addEventListener("submit",(function (p1__9588_SHARP_){
var e = p1__9588_SHARP_.target;
if(cljs.core.truth_((function (){var or__7184__auto__ = e.getAttribute("action");
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return e.getAttribute("method");
}
})())){
return null;
} else {
return p1__9588_SHARP_.preventDefault();
}
}));
}));
if(typeof hoplon.core.do_BANG_ !== 'undefined'){
} else {
hoplon.core.do_BANG_ = (function (){var method_table__8117__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8118__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8119__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8120__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8121__auto__ = cljs.core.get.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365)], null),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hoplon.core","do!"),((function (method_table__8117__auto__,prefer_table__8118__auto__,method_cache__8119__auto__,cached_hierarchy__8120__auto__,hierarchy__8121__auto__){
return (function (elem,key,val){
var temp__4655__auto__ = cljs.core.namespace.call(null,key);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return cljs.core.keyword.call(null,n,"*");
} else {
return key;
}
});})(method_table__8117__auto__,prefer_table__8118__auto__,method_cache__8119__auto__,cached_hierarchy__8120__auto__,hierarchy__8121__auto__))
,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),hierarchy__8121__auto__,method_table__8117__auto__,prefer_table__8118__auto__,method_cache__8119__auto__,cached_hierarchy__8120__auto__));
})();
}
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),(function (elem,key,val){
return hoplon.core.do_BANG_.call(null,elem,new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.PersistentArrayMap.createAsIfByAssoc([key,val]));
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("css","*","css/*",-1295355419),(function (elem,key,val){
return hoplon.core.set_styles_BANG_.call(null,elem,key,val);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("html","*","html/*",-1283138243),(function (elem,key,val){
return hoplon.core.set_attributes_BANG_.call(null,elem,key,val);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("svg","*","svg/*",-1295405562),(function (elem,key,val){
return hoplon.core.set_attributes_BANG_.call(null,elem,key,val);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword(null,"attr","attr",-604132353),(function (elem,_,kvs){
return hoplon.core.set_attributes_BANG_.call(null,elem,kvs);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword(null,"css","css",1135045163),(function (elem,_,kvs){
return hoplon.core.set_styles_BANG_.call(null,elem,kvs);
}));
if(typeof hoplon.core.on_BANG_ !== 'undefined'){
} else {
hoplon.core.on_BANG_ = (function (){var method_table__8117__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8118__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8119__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8120__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8121__auto__ = cljs.core.get.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365)], null),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hoplon.core","on!"),((function (method_table__8117__auto__,prefer_table__8118__auto__,method_cache__8119__auto__,cached_hierarchy__8120__auto__,hierarchy__8121__auto__){
return (function (elem,key,val){
var temp__4655__auto__ = cljs.core.namespace.call(null,key);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return cljs.core.keyword.call(null,n,"*");
} else {
return key;
}
});})(method_table__8117__auto__,prefer_table__8118__auto__,method_cache__8119__auto__,cached_hierarchy__8120__auto__,hierarchy__8121__auto__))
,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),hierarchy__8121__auto__,method_table__8117__auto__,prefer_table__8118__auto__,method_cache__8119__auto__,cached_hierarchy__8120__auto__));
})();
}
cljs.core._add_method.call(null,hoplon.core.on_BANG_,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),(function (elem,event,callback){
return hoplon.core.when_dom.call(null,elem,(function (){
return elem.addEventListener(cljs.core.name.call(null,event),callback);
}));
}));
cljs.core._add_method.call(null,hoplon.core.on_BANG_,new cljs.core.Keyword("html","*","html/*",-1283138243),(function (elem,event,callback){
return hoplon.core.when_dom.call(null,elem,(function (){
return elem.addEventListener(cljs.core.name.call(null,event),callback);
}));
}));
/**
 * Given a cell items containing a seqable collection, constructs a cell that
 *   works like a fill vector. The template tpl is a function of one argument: the
 *   formula cell containing the ith item in items. The tpl function is called
 *   once (and only once) for each index in items. When the items collection
 *   shrinks the DOM element created by the template is not destroyed--it is only
 *   removed from the DOM and cached. When the items collection grows again those
 *   cached elements will be reinserted into the DOM at their original index.
 */
hoplon.core.loop_tpl_STAR_ = (function hoplon$core$loop_tpl_STAR_(items,tpl){
var on_deck = cljs.core.atom.call(null,cljs.core.List.EMPTY);
var items_seq = javelin.core.formula.call(null,((function (on_deck){
return (function (G__9600,G__9601){
return G__9600.call(null,G__9601);
});})(on_deck))
).call(null,cljs.core.seq,items);
var ith_item = ((function (on_deck,items_seq){
return (function (p1__9589_SHARP_){
return javelin.core.formula.call(null,((function (on_deck,items_seq){
return (function (G__9604,G__9603,G__9602){
return G__9602.call(null,G__9603,G__9604);
});})(on_deck,items_seq))
).call(null,p1__9589_SHARP_,items_seq,hoplon.core.safe_nth);
});})(on_deck,items_seq))
;
var shift_BANG_ = ((function (on_deck,items_seq,ith_item){
return (function (p1__9590_SHARP_){
var x = cljs.core.first.call(null,cljs.core.deref.call(null,p1__9590_SHARP_));
cljs.core.swap_BANG_.call(null,p1__9590_SHARP_,cljs.core.rest);

return x;
});})(on_deck,items_seq,ith_item))
;
var current = javelin.core.cell.call(null,cljs.core.PersistentVector.EMPTY);
hoplon.core.do_watch.call(null,items_seq,((function (current,on_deck,items_seq,ith_item,shift_BANG_){
return (function (old_items,new_items){
var old = cljs.core.count.call(null,old_items);
var new$ = cljs.core.count.call(null,new_items);
var diff = (new$ - old);
if((diff > (0))){
var seq__9605 = cljs.core.seq.call(null,cljs.core.range.call(null,old,new$));
var chunk__9606 = null;
var count__9607 = (0);
var i__9608 = (0);
while(true){
if((i__9608 < count__9607)){
var i = cljs.core._nth.call(null,chunk__9606,i__9608);
var e_9609 = (function (){var or__7184__auto__ = shift_BANG_.call(null,on_deck);
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return tpl.call(null,ith_item.call(null,i));
}
})();
cljs.core.swap_BANG_.call(null,current,cljs.core.conj,e_9609);

var G__9610 = seq__9605;
var G__9611 = chunk__9606;
var G__9612 = count__9607;
var G__9613 = (i__9608 + (1));
seq__9605 = G__9610;
chunk__9606 = G__9611;
count__9607 = G__9612;
i__9608 = G__9613;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9605);
if(temp__4657__auto__){
var seq__9605__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9605__$1)){
var c__8003__auto__ = cljs.core.chunk_first.call(null,seq__9605__$1);
var G__9614 = cljs.core.chunk_rest.call(null,seq__9605__$1);
var G__9615 = c__8003__auto__;
var G__9616 = cljs.core.count.call(null,c__8003__auto__);
var G__9617 = (0);
seq__9605 = G__9614;
chunk__9606 = G__9615;
count__9607 = G__9616;
i__9608 = G__9617;
continue;
} else {
var i = cljs.core.first.call(null,seq__9605__$1);
var e_9618 = (function (){var or__7184__auto__ = shift_BANG_.call(null,on_deck);
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return tpl.call(null,ith_item.call(null,i));
}
})();
cljs.core.swap_BANG_.call(null,current,cljs.core.conj,e_9618);

var G__9619 = cljs.core.next.call(null,seq__9605__$1);
var G__9620 = null;
var G__9621 = (0);
var G__9622 = (0);
seq__9605 = G__9619;
chunk__9606 = G__9620;
count__9607 = G__9621;
i__9608 = G__9622;
continue;
}
} else {
return null;
}
}
break;
}
} else {
if((diff < (0))){
var n__8107__auto__ = (- diff);
var _ = (0);
while(true){
if((_ < n__8107__auto__)){
var e_9623 = cljs.core.peek.call(null,cljs.core.deref.call(null,current));
cljs.core.swap_BANG_.call(null,current,cljs.core.pop);

cljs.core.swap_BANG_.call(null,on_deck,cljs.core.conj,e_9623);

var G__9624 = (_ + (1));
_ = G__9624;
continue;
} else {
return null;
}
break;
}
} else {
return null;
}
}
});})(current,on_deck,items_seq,ith_item,shift_BANG_))
);

return current;
});
/**
 * Defines a cell whose value is the URI fragment.
 */
hoplon.core.route_cell = (function hoplon$core$route_cell(var_args){
var args__8304__auto__ = [];
var len__8297__auto___9633 = arguments.length;
var i__8298__auto___9634 = (0);
while(true){
if((i__8298__auto___9634 < len__8297__auto___9633)){
args__8304__auto__.push((arguments[i__8298__auto___9634]));

var G__9635 = (i__8298__auto___9634 + (1));
i__8298__auto___9634 = G__9635;
continue;
} else {
}
break;
}

var argseq__8305__auto__ = ((((0) < args__8304__auto__.length))?(new cljs.core.IndexedSeq(args__8304__auto__.slice((0)),(0),null)):null);
return hoplon.core.route_cell.cljs$core$IFn$_invoke$arity$variadic(argseq__8305__auto__);
});

hoplon.core.route_cell.cljs$core$IFn$_invoke$arity$variadic = (function (p__9626){
var vec__9627 = p__9626;
var default$ = cljs.core.nth.call(null,vec__9627,(0),null);
var c = javelin.core.cell.call(null,window.location.hash);
var _ = javelin.core.formula.call(null,((function (c,vec__9627,default$){
return (function (G__9630,G__9632,G__9631){
var or__7184__auto__ = (function (){var and__7172__auto__ = G__9630.call(null,G__9631);
if(cljs.core.truth_(and__7172__auto__)){
return G__9631;
} else {
return and__7172__auto__;
}
})();
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return G__9632;
}
});})(c,vec__9627,default$))
).call(null,cljs.core.seq,default$,c);
window.addEventListener("hashchange",((function (_,c,vec__9627,default$){
return (function (){
return cljs.core.reset_BANG_.call(null,c,window.location.hash);
});})(_,c,vec__9627,default$))
);

return _;
});

hoplon.core.route_cell.cljs$lang$maxFixedArity = (0);

hoplon.core.route_cell.cljs$lang$applyTo = (function (seq9625){
return hoplon.core.route_cell.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq9625));
});


//# sourceMappingURL=core.js.map