'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.events = exports.eventMappings = undefined;
exports.convertFilterData = convertFilterData;
exports.promisify = promisify;
exports.normalizeError = normalizeError;
exports.normalizeArgs = normalizeArgs;

var _feathersCommons = require('feathers-commons');

var eventMappings = exports.eventMappings = {
  create: 'created',
  update: 'updated',
  patch: 'patched',
  remove: 'removed'
};

var events = exports.events = Object.keys(eventMappings).map(function (method) {
  return eventMappings[method];
});

function convertFilterData(obj) {
  return _feathersCommons.hooks.convertHookData(obj);
}

function promisify(method, context) {
  for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    args[_key - 2] = arguments[_key];
  }

  return new Promise(function (resolve, reject) {
    method.apply(context, args.concat(function (error, result) {
      if (error) {
        return reject(error);
      }

      resolve(result);
    }));
  });
}

function normalizeError(e) {
  var result = {};

  Object.getOwnPropertyNames(e).forEach(function (key) {
    return result[key] = e[key];
  });

  if (process.env.NODE_ENV === 'production') {
    delete result.stack;
  }

  delete result.hook;

  return result;
}

function normalizeArgs(args) {
  var ret = [];
  if (args.length === 2 && Array.isArray(args['0'])) {
    ret = args[0];
    ret.push(args[1]);
    return ret;
  }
  return args;
}