// Compiled by ClojureScript 1.9.542 {}
goog.provide('schema.utils');
goog.require('cljs.core');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('clojure.string');
/**
 * Like assoc but only assocs when value is truthy.  Copied from plumbing.core so that
 * schema need not depend on plumbing.
 */
schema.utils.assoc_when = (function schema$utils$assoc_when(var_args){
var args__8304__auto__ = [];
var len__8297__auto___10140 = arguments.length;
var i__8298__auto___10141 = (0);
while(true){
if((i__8298__auto___10141 < len__8297__auto___10140)){
args__8304__auto__.push((arguments[i__8298__auto___10141]));

var G__10142 = (i__8298__auto___10141 + (1));
i__8298__auto___10141 = G__10142;
continue;
} else {
}
break;
}

var argseq__8305__auto__ = ((((1) < args__8304__auto__.length))?(new cljs.core.IndexedSeq(args__8304__auto__.slice((1)),(0),null)):null);
return schema.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8305__auto__);
});

schema.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

return cljs.core.into.call(null,(function (){var or__7184__auto__ = m;
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__7972__auto__ = (function schema$utils$iter__10124(s__10125){
return (new cljs.core.LazySeq(null,(function (){
var s__10125__$1 = s__10125;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__10125__$1);
if(temp__4657__auto__){
var s__10125__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10125__$2)){
var c__7970__auto__ = cljs.core.chunk_first.call(null,s__10125__$2);
var size__7971__auto__ = cljs.core.count.call(null,c__7970__auto__);
var b__10127 = cljs.core.chunk_buffer.call(null,size__7971__auto__);
if((function (){var i__10126 = (0);
while(true){
if((i__10126 < size__7971__auto__)){
var vec__10134 = cljs.core._nth.call(null,c__7970__auto__,i__10126);
var k = cljs.core.nth.call(null,vec__10134,(0),null);
var v = cljs.core.nth.call(null,vec__10134,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__10127,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__10143 = (i__10126 + (1));
i__10126 = G__10143;
continue;
} else {
var G__10144 = (i__10126 + (1));
i__10126 = G__10144;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10127),schema$utils$iter__10124.call(null,cljs.core.chunk_rest.call(null,s__10125__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10127),null);
}
} else {
var vec__10137 = cljs.core.first.call(null,s__10125__$2);
var k = cljs.core.nth.call(null,vec__10137,(0),null);
var v = cljs.core.nth.call(null,vec__10137,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),schema$utils$iter__10124.call(null,cljs.core.rest.call(null,s__10125__$2)));
} else {
var G__10145 = cljs.core.rest.call(null,s__10125__$2);
s__10125__$1 = G__10145;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7972__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

schema.utils.assoc_when.cljs$lang$maxFixedArity = (1);

schema.utils.assoc_when.cljs$lang$applyTo = (function (seq10122){
var G__10123 = cljs.core.first.call(null,seq10122);
var seq10122__$1 = cljs.core.next.call(null,seq10122);
return schema.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__10123,seq10122__$1);
});

schema.utils.type_of = (function schema$utils$type_of(x){
return typeof x;
});
/**
 * What class can we associate the fn schema with? In Clojure use the class of the fn; in
 * cljs just use the fn itself.
 */
schema.utils.fn_schema_bearer = (function schema$utils$fn_schema_bearer(f){
return f;
});
schema.utils.format_STAR_ = (function schema$utils$format_STAR_(var_args){
var args__8304__auto__ = [];
var len__8297__auto___10148 = arguments.length;
var i__8298__auto___10149 = (0);
while(true){
if((i__8298__auto___10149 < len__8297__auto___10148)){
args__8304__auto__.push((arguments[i__8298__auto___10149]));

var G__10150 = (i__8298__auto___10149 + (1));
i__8298__auto___10149 = G__10150;
continue;
} else {
}
break;
}

var argseq__8305__auto__ = ((((1) < args__8304__auto__.length))?(new cljs.core.IndexedSeq(args__8304__auto__.slice((1)),(0),null)):null);
return schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8305__auto__);
});

schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

schema.utils.format_STAR_.cljs$lang$maxFixedArity = (1);

schema.utils.format_STAR_.cljs$lang$applyTo = (function (seq10146){
var G__10147 = cljs.core.first.call(null,seq10146);
var seq10146__$1 = cljs.core.next.call(null,seq10146);
return schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__10147,seq10146__$1);
});

schema.utils.max_value_length = cljs.core.atom.call(null,(19));
/**
 * Provide a descriptive short name for a value.
 */
schema.utils.value_name = (function schema$utils$value_name(value){
var t = schema.utils.type_of.call(null,value);
if((cljs.core.count.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('')) <= cljs.core.deref.call(null,schema.utils.max_value_length))){
return value;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("a-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(t)].join(''));
}
});
/**
 * TODO: eventually use built in demunge in latest cljs.
 */
schema.utils.unmunge = (function schema$utils$unmunge(s){
return cljs.core.reduce.call(null,(function (s__$1,p__10156){
var vec__10157 = p__10156;
var to = cljs.core.nth.call(null,vec__10157,(0),null);
var from = cljs.core.nth.call(null,vec__10157,(1),null);
return clojure.string.replace.call(null,s__$1,from,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(to)].join(''));
}),s,cljs.core.sort_by.call(null,(function (p1__10151_SHARP_){
return (- cljs.core.count.call(null,cljs.core.second.call(null,p1__10151_SHARP_)));
}),cljs.core.PersistentHashMap.fromArrays(["@","!","\"","#","%","&","'","*","+","-","/",":","[","{","<","\\","|","=","]","}",">","^","~","?"],["_CIRCA_","_BANG_","_DOUBLEQUOTE_","_SHARP_","_PERCENT_","_AMPERSAND_","_SINGLEQUOTE_","_STAR_","_PLUS_","_","_SLASH_","_COLON_","_LBRACK_","_LBRACE_","_LT_","_BSLASH_","_BAR_","_EQ_","_RBRACK_","_RBRACE_","_GT_","_CARET_","_TILDE_","_QMARK_"])));
});
/**
 * A meaningful name for a function that looks like its symbol, if applicable.
 */
schema.utils.fn_name = (function schema$utils$fn_name(f){
return schema.utils.unmunge.call(null,(function (){var or__7184__auto__ = cljs.core.not_empty.call(null,cljs.core.second.call(null,cljs.core.re_find.call(null,/function ([^\(]*)\(/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''))));
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return "function";
}
})());
});
schema.utils.record_QMARK_ = (function schema$utils$record_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IRecord,x);
}
});

/**
* @constructor
 * @implements {cljs.core.IPrintWithWriter}
*/
schema.utils.ValidationError = (function (schema,value,expectation_delay,fail_explanation){
this.schema = schema;
this.value = value;
this.expectation_delay = expectation_delay;
this.fail_explanation = fail_explanation;
this.cljs$lang$protocol_mask$partition0$ = 2147483648;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
schema.utils.ValidationError.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._pr_writer.call(null,schema.utils.validation_error_explain.call(null,this$__$1),writer,opts);
});

schema.utils.ValidationError.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"expectation-delay","expectation-delay",-1886214669,null),new cljs.core.Symbol(null,"fail-explanation","fail-explanation",530278923,null)], null);
});

schema.utils.ValidationError.cljs$lang$type = true;

schema.utils.ValidationError.cljs$lang$ctorStr = "schema.utils/ValidationError";

schema.utils.ValidationError.cljs$lang$ctorPrWriter = (function (this__7795__auto__,writer__7796__auto__,opt__7797__auto__){
return cljs.core._write.call(null,writer__7796__auto__,"schema.utils/ValidationError");
});

schema.utils.__GT_ValidationError = (function schema$utils$__GT_ValidationError(schema__$1,value,expectation_delay,fail_explanation){
return (new schema.utils.ValidationError(schema__$1,value,expectation_delay,fail_explanation));
});

schema.utils.validation_error_explain = (function schema$utils$validation_error_explain(err){
var x__8026__auto__ = (function (){var or__7184__auto__ = err.fail_explanation;
if(cljs.core.truth_(or__7184__auto__)){
return or__7184__auto__;
} else {
return new cljs.core.Symbol(null,"not","not",1044554643,null);
}
})();
return cljs.core._conj.call(null,(function (){var x__8026__auto____$1 = cljs.core.deref.call(null,err.expectation_delay);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8026__auto____$1);
})(),x__8026__auto__);
});
/**
 * for cljs sake (easier than normalizing imports in macros.clj)
 */
schema.utils.make_ValidationError = (function schema$utils$make_ValidationError(schema__$1,value,expectation_delay,fail_explanation){
return (new schema.utils.ValidationError(schema__$1,value,expectation_delay,fail_explanation));
});

/**
* @constructor
 * @implements {cljs.core.IPrintWithWriter}
*/
schema.utils.NamedError = (function (name,error){
this.name = name;
this.error = error;
this.cljs$lang$protocol_mask$partition0$ = 2147483648;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
schema.utils.NamedError.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._pr_writer.call(null,schema.utils.named_error_explain.call(null,this$__$1),writer,opts);
});

schema.utils.NamedError.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"error","error",661562495,null)], null);
});

schema.utils.NamedError.cljs$lang$type = true;

schema.utils.NamedError.cljs$lang$ctorStr = "schema.utils/NamedError";

schema.utils.NamedError.cljs$lang$ctorPrWriter = (function (this__7795__auto__,writer__7796__auto__,opt__7797__auto__){
return cljs.core._write.call(null,writer__7796__auto__,"schema.utils/NamedError");
});

schema.utils.__GT_NamedError = (function schema$utils$__GT_NamedError(name,error){
return (new schema.utils.NamedError(name,error));
});

schema.utils.named_error_explain = (function schema$utils$named_error_explain(err){
return cljs.core._conj.call(null,(function (){var x__8026__auto__ = err.error;
return cljs.core._conj.call(null,(function (){var x__8026__auto____$1 = err.name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8026__auto____$1);
})(),x__8026__auto__);
})(),new cljs.core.Symbol(null,"named","named",1218138048,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.utils.ErrorContainer = (function (error,__meta,__extmap,__hash){
this.error = error;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.utils.ErrorContainer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7811__auto__,k__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
return this__7811__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7812__auto__,null);
});

schema.utils.ErrorContainer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7813__auto__,k10163,else__7814__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
var G__10165 = k10163;
var G__10165__$1 = (((G__10165 instanceof cljs.core.Keyword))?G__10165.fqn:null);
switch (G__10165__$1) {
case "error":
return self__.error;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k10163,else__7814__auto__);

}
});

schema.utils.ErrorContainer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7825__auto__,writer__7826__auto__,opts__7827__auto__){
var self__ = this;
var this__7825__auto____$1 = this;
var pr_pair__7828__auto__ = ((function (this__7825__auto____$1){
return (function (keyval__7829__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7826__auto__,cljs.core.pr_writer,""," ","",opts__7827__auto__,keyval__7829__auto__);
});})(this__7825__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7826__auto__,pr_pair__7828__auto__,"#schema.utils.ErrorContainer{",", ","}",opts__7827__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null))], null),self__.__extmap));
});

schema.utils.ErrorContainer.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.utils.ErrorContainer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10162){
var self__ = this;
var G__10162__$1 = this;
return (new cljs.core.RecordIter((0),G__10162__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.utils.ErrorContainer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7809__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return self__.__meta;
});

schema.utils.ErrorContainer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7805__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
return (new schema.utils.ErrorContainer(self__.error,self__.__meta,self__.__extmap,self__.__hash));
});

schema.utils.ErrorContainer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7815__auto__){
var self__ = this;
var this__7815__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.utils.ErrorContainer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7806__auto__){
var self__ = this;
var this__7806__auto____$1 = this;
var h__7624__auto__ = self__.__hash;
if(!((h__7624__auto__ == null))){
return h__7624__auto__;
} else {
var h__7624__auto____$1 = cljs.core.hash_imap.call(null,this__7806__auto____$1);
self__.__hash = h__7624__auto____$1;

return h__7624__auto____$1;
}
});

schema.utils.ErrorContainer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7807__auto__,other__7808__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7172__auto__ = other__7808__auto__;
if(cljs.core.truth_(and__7172__auto__)){
return ((this__7807__auto____$1.constructor === other__7808__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7807__auto____$1,other__7808__auto__));
} else {
return and__7172__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.utils.ErrorContainer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7820__auto__,k__7821__auto__){
var self__ = this;
var this__7820__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),null], null), null),k__7821__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7820__auto____$1),self__.__meta),k__7821__auto__);
} else {
return (new schema.utils.ErrorContainer(self__.error,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7821__auto__)),null));
}
});

schema.utils.ErrorContainer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7818__auto__,k__7819__auto__,G__10162){
var self__ = this;
var this__7818__auto____$1 = this;
var pred__10166 = cljs.core.keyword_identical_QMARK_;
var expr__10167 = k__7819__auto__;
if(cljs.core.truth_(pred__10166.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__10167))){
return (new schema.utils.ErrorContainer(G__10162,self__.__meta,self__.__extmap,null));
} else {
return (new schema.utils.ErrorContainer(self__.error,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7819__auto__,G__10162),null));
}
});

schema.utils.ErrorContainer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7823__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null))], null),self__.__extmap));
});

schema.utils.ErrorContainer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7810__auto__,G__10162){
var self__ = this;
var this__7810__auto____$1 = this;
return (new schema.utils.ErrorContainer(self__.error,G__10162,self__.__extmap,self__.__hash));
});

schema.utils.ErrorContainer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7816__auto__,entry__7817__auto__){
var self__ = this;
var this__7816__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7817__auto__)){
return this__7816__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7817__auto__,(0)),cljs.core._nth.call(null,entry__7817__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7816__auto____$1,entry__7817__auto__);
}
});

schema.utils.ErrorContainer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null)], null);
});

schema.utils.ErrorContainer.cljs$lang$type = true;

schema.utils.ErrorContainer.cljs$lang$ctorPrSeq = (function (this__7845__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.utils/ErrorContainer");
});

schema.utils.ErrorContainer.cljs$lang$ctorPrWriter = (function (this__7845__auto__,writer__7846__auto__){
return cljs.core._write.call(null,writer__7846__auto__,"schema.utils/ErrorContainer");
});

schema.utils.__GT_ErrorContainer = (function schema$utils$__GT_ErrorContainer(error){
return (new schema.utils.ErrorContainer(error,null,null,null));
});

schema.utils.map__GT_ErrorContainer = (function schema$utils$map__GT_ErrorContainer(G__10164){
return (new schema.utils.ErrorContainer(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__10164),null,cljs.core.dissoc.call(null,G__10164,new cljs.core.Keyword(null,"error","error",-978969032)),null));
});

/**
 * Distinguish a value (must be non-nil) as an error.
 */
schema.utils.error = (function schema$utils$error(x){
if(cljs.core.truth_(x)){
} else {
throw (new Error("Assert failed: x"));
}

return schema.utils.__GT_ErrorContainer.call(null,x);
});
schema.utils.error_QMARK_ = (function schema$utils$error_QMARK_(x){
return (x instanceof schema.utils.ErrorContainer);
});
schema.utils.error_val = (function schema$utils$error_val(x){
if(cljs.core.truth_(schema.utils.error_QMARK_.call(null,x))){
return x.error;
} else {
return null;
}
});
schema.utils.declare_class_schema_BANG_ = (function schema$utils$declare_class_schema_BANG_(klass,schema__$1){
return (klass["schema$utils$schema"] = schema__$1);
});

schema.utils.class_schema = (function schema$utils$class_schema(klass){
return (klass["schema$utils$schema"]);
});
/**
 * Turn on run-time function validation for functions compiled when
 * s/compile-fn-validation was true -- has no effect for functions compiled
 * when it is false.
 */
schema.utils.use_fn_validation = cljs.core.atom.call(null,false);

//# sourceMappingURL=utils.js.map