// Compiled by ClojureScript 1.9.521 {:target :nodejs}
goog.provide('feathers.app');
goog.require('cljs.core');
goog.require('feathers.authentication');
goog.require('feathers.core');
goog.require('feathers.cors');
goog.require('feathers.configuration');
goog.require('feathers.compression');
goog.require('feathers.favicon');
goog.require('feathers.body_parser');
goog.require('feathers.hooks');
goog.require('feathers.rest');
goog.require('feathers.socketio');
goog.require('feathers.express');
goog.require('feathers.memory');
feathers.app.feathers = (function feathers$app$feathers(){
return feathers.core.feathers.call(null);
});
feathers.app.configuration = feathers.configuration.configure;
feathers.app.compress = feathers.compression.using;
feathers.app.cors = (function feathers$app$cors(app){
return feathers.cors.using.call(null,feathers.express.options.call(null,app,"*",feathers.cors.cors.call(null)));
});
feathers.app.favicon = feathers.favicon.using;
feathers.app.body_parser = (function feathers$app$body_parser(app){
return feathers.body_parser.urlencoded.call(null,feathers.body_parser.json.call(null,app),({"extended": true}));
});
feathers.app.hooks = feathers.hooks.configure;
feathers.app.rest = feathers.rest.configure;
feathers.app.socketio = feathers.socketio.configure;
feathers.app.memory = feathers.memory.using;
feathers.app.authentication = (function feathers$app$authentication(app){
var conf = app.get("auth");
var app__$1 = feathers.authentication.configure.call(null,app,conf);
return feathers.authentication.service.call(null,app__$1);
});
feathers.app.static$ = (function feathers$app$static(feathers__$1,path){
return feathers.core.using.call(null,feathers__$1,feathers.core.static$.call(null,path));
});
feathers.app.listen = feathers.core.listen;
feathers.app.api = (function feathers$app$api(var_args){
var args__8302__auto__ = [];
var len__8295__auto___8432 = arguments.length;
var i__8296__auto___8433 = (0);
while(true){
if((i__8296__auto___8433 < len__8295__auto___8432)){
args__8302__auto__.push((arguments[i__8296__auto___8433]));

var G__8434 = (i__8296__auto___8433 + (1));
i__8296__auto___8433 = G__8434;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((3) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((3)),(0),null)):null);
return feathers.app.api.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8303__auto__);
});

feathers.app.api.cljs$core$IFn$_invoke$arity$variadic = (function (app,path,svc,p__8425){
var vec__8426 = p__8425;
var hooks = cljs.core.nth.call(null,vec__8426,(0),null);
var app__$1 = feathers.core.using.call(null,app,path,svc);
var map__8429 = hooks;
var map__8429__$1 = ((((!((map__8429 == null)))?((((map__8429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8429.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8429):map__8429);
var before = cljs.core.get.call(null,map__8429__$1,new cljs.core.Keyword(null,"before","before",-1633692388));
var after = cljs.core.get.call(null,map__8429__$1,new cljs.core.Keyword(null,"after","after",594996914));
var G__8431_8435 = feathers.core.service.call(null,app__$1,path);
G__8431_8435.before(cljs.core.clj__GT_js.call(null,before));

G__8431_8435.after(cljs.core.clj__GT_js.call(null,after));


return app__$1;
});

feathers.app.api.cljs$lang$maxFixedArity = (3);

feathers.app.api.cljs$lang$applyTo = (function (seq8421){
var G__8422 = cljs.core.first.call(null,seq8421);
var seq8421__$1 = cljs.core.next.call(null,seq8421);
var G__8423 = cljs.core.first.call(null,seq8421__$1);
var seq8421__$2 = cljs.core.next.call(null,seq8421__$1);
var G__8424 = cljs.core.first.call(null,seq8421__$2);
var seq8421__$3 = cljs.core.next.call(null,seq8421__$2);
return feathers.app.api.cljs$core$IFn$_invoke$arity$variadic(G__8422,G__8423,G__8424,seq8421__$3);
});


//# sourceMappingURL=app.js.map