'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _qs = require('qs');

var _qs2 = _interopRequireDefault(_qs);

var _feathersCommons = require('feathers-commons');

var _feathersErrors = require('feathers-errors');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function toError(error) {
  throw (0, _feathersErrors.convert)(error);
}

var Base = function () {
  function Base(settings) {
    _classCallCheck(this, Base);

    this.name = (0, _feathersCommons.stripSlashes)(settings.name);
    this.options = settings.options;
    this.connection = settings.connection;
    this.base = settings.base + '/' + this.name;
  }

  _createClass(Base, [{
    key: 'makeUrl',
    value: function makeUrl(params, id) {
      params = params || {};
      var url = this.base;

      if (typeof id !== 'undefined' && id !== null) {
        url += '/' + id;
      }

      if (Object.keys(params).length !== 0) {
        var queryString = _qs2.default.stringify(params);

        url += '?' + queryString;
      }

      return url;
    }
  }, {
    key: 'find',
    value: function find() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return this.request({
        url: this.makeUrl(params.query),
        method: 'GET',
        headers: _extends({}, params.headers)
      }).catch(toError);
    }
  }, {
    key: 'get',
    value: function get(id) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (typeof id === 'undefined') {
        return Promise.reject(new Error('id for \'get\' can not be undefined'));
      }

      return this.request({
        url: this.makeUrl(params.query, id),
        method: 'GET',
        headers: _extends({}, params.headers)
      }).catch(toError);
    }
  }, {
    key: 'create',
    value: function create(body) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return this.request({
        url: this.makeUrl(params.query),
        body: body,
        method: 'POST',
        headers: _extends({ 'Content-Type': 'application/json' }, params.headers)
      }).catch(toError);
    }
  }, {
    key: 'update',
    value: function update(id, body) {
      var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      if (typeof id === 'undefined') {
        return Promise.reject(new Error('id for \'update\' can not be undefined, only \'null\' when updating multiple entries'));
      }

      return this.request({
        url: this.makeUrl(params.query, id),
        body: body,
        method: 'PUT',
        headers: _extends({ 'Content-Type': 'application/json' }, params.headers)
      }).catch(toError);
    }
  }, {
    key: 'patch',
    value: function patch(id, body) {
      var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      if (typeof id === 'undefined') {
        return Promise.reject(new Error('id for \'patch\' can not be undefined, only \'null\' when updating multiple entries'));
      }

      return this.request({
        url: this.makeUrl(params.query, id),
        body: body,
        method: 'PATCH',
        headers: _extends({ 'Content-Type': 'application/json' }, params.headers)
      }).catch(toError);
    }
  }, {
    key: 'remove',
    value: function remove(id) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (typeof id === 'undefined') {
        return Promise.reject(new Error('id for \'remove\' can not be undefined, only \'null\' when removing multiple entries'));
      }

      return this.request({
        url: this.makeUrl(params.query, id),
        method: 'DELETE',
        headers: _extends({}, params.headers)
      }).catch(toError);
    }
  }]);

  return Base;
}();

exports.default = Base;
module.exports = exports['default'];