// Compiled by ClojureScript 1.9.521 {}
goog.provide('hoplon.core');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('javelin.core');
goog.require('cljs.reader');
goog.require('clojure.string');



cljs.core.enable_console_print_BANG_.call(null);
/**
 * Is the application running in a prerendering container (eg. PhantomJS via
 *   the prerender task)?
 */
hoplon.core.prerendering_QMARK_ = (new goog.Uri(window.location.href)).getParameterValue("prerendering");
/**
 * This is an internal implementation detail, exposed for the convenience of
 *   the hoplon.core/static macro. Experimental.
 */
hoplon.core.static_elements = cljs.core.reduce.call(null,(function (p1__9237_SHARP_,p2__9238_SHARP_){
return cljs.core.assoc.call(null,p1__9237_SHARP_,p2__9238_SHARP_.getAttribute("static-id"),p2__9238_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,document.querySelector("[static-id]"));
/**
 * Public helper.
 *   Adds f as a watcher to ref and evaluates (f init @ref) once. The watcher
 *   f is a function of two arguments: the previous and next values. If init is
 *   not provided the default (nil) will be used.
 */
hoplon.core.do_watch = (function hoplon$core$do_watch(var_args){
var args9239 = [];
var len__8295__auto___9242 = arguments.length;
var i__8296__auto___9243 = (0);
while(true){
if((i__8296__auto___9243 < len__8295__auto___9242)){
args9239.push((arguments[i__8296__auto___9243]));

var G__9244 = (i__8296__auto___9243 + (1));
i__8296__auto___9243 = G__9244;
continue;
} else {
}
break;
}

var G__9241 = args9239.length;
switch (G__9241) {
case 2:
return hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9239.length)].join('')));

}
});

hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$2 = (function (ref,f){
return hoplon.core.do_watch.call(null,ref,null,f);
});

hoplon.core.do_watch.cljs$core$IFn$_invoke$arity$3 = (function (ref,init,f){
var k = cljs.core.gensym.call(null);
f.call(null,init,cljs.core.deref.call(null,ref));

cljs.core.add_watch.call(null,ref,k,((function (k){
return (function (_,___$1,old,new$){
return f.call(null,old,new$);
});})(k))
);

return k;
});

hoplon.core.do_watch.cljs$lang$maxFixedArity = 3;

/**
 * Public helper.
 *   Experimental.
 */
hoplon.core.bust_cache = (function hoplon$core$bust_cache(path){
var vec__9252 = cljs.core.reverse.call(null,clojure.string.split.call(null,path,/\//));
var seq__9253 = cljs.core.seq.call(null,vec__9252);
var first__9254 = cljs.core.first.call(null,seq__9253);
var seq__9253__$1 = cljs.core.next.call(null,seq__9253);
var f = first__9254;
var more = seq__9253__$1;
var vec__9255 = clojure.string.split.call(null,f,/\./,(2));
var f1 = cljs.core.nth.call(null,vec__9255,(0),null);
var f2 = cljs.core.nth.call(null,vec__9255,(1),null);
return clojure.string.join.call(null,"/",cljs.core.reverse.call(null,cljs.core.conj.call(null,more,clojure.string.join.call(null,".",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(f1),cljs.core.str.cljs$core$IFn$_invoke$arity$1("."),cljs.core.str.cljs$core$IFn$_invoke$arity$1("79ff6207ac314269ab9dbdfc205db16e")].join(''),f2], null)))));
});
/**
 * Public helper.
 *   Class normalization for attribute providers.
 */
hoplon.core.normalize_class = (function hoplon$core$normalize_class(kvs){
var __GT_map = (function (p1__9258_SHARP_){
return cljs.core.zipmap.call(null,p1__9258_SHARP_,cljs.core.repeat.call(null,true));
});
if(cljs.core.map_QMARK_.call(null,kvs)){
return kvs;
} else {
return __GT_map.call(null,((typeof kvs === 'string')?kvs.split(/\s+/):cljs.core.seq.call(null,kvs)));
}
});
hoplon.core.child_vec = (function hoplon$core$child_vec(this$){
var x = this$.childNodes;
var l = x.length;
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
while(true){
var or__7182__auto__ = (function (){var and__7170__auto__ = cljs.core._EQ_.call(null,i,l);
if(and__7170__auto__){
return cljs.core.persistent_BANG_.call(null,ret);
} else {
return and__7170__auto__;
}
})();
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
var G__9259 = (i + (1));
var G__9260 = cljs.core.conj_BANG_.call(null,ret,x.item(i));
i = G__9259;
ret = G__9260;
continue;
}
break;
}
});
hoplon.core.vflatten = (function hoplon$core$vflatten(var_args){
var args9261 = [];
var len__8295__auto___9264 = arguments.length;
var i__8296__auto___9265 = (0);
while(true){
if((i__8296__auto___9265 < len__8295__auto___9264)){
args9261.push((arguments[i__8296__auto___9265]));

var G__9266 = (i__8296__auto___9265 + (1));
i__8296__auto___9265 = G__9266;
continue;
} else {
}
break;
}

var G__9263 = args9261.length;
switch (G__9263) {
case 1:
return hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9261.length)].join('')));

}
});

hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$1 = (function (tree){
return cljs.core.persistent_BANG_.call(null,hoplon.core.vflatten.call(null,tree,cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY)));
});

hoplon.core.vflatten.cljs$core$IFn$_invoke$arity$2 = (function (tree,ret){
var l = cljs.core.count.call(null,tree);
var i = (0);
while(true){
if(cljs.core._EQ_.call(null,i,l)){
return ret;
} else {
var x = cljs.core.nth.call(null,tree,i);
if(!(cljs.core.sequential_QMARK_.call(null,x))){
cljs.core.conj_BANG_.call(null,ret,x);
} else {
hoplon.core.vflatten.call(null,x,ret);
}

var G__9268 = (i + (1));
i = G__9268;
continue;
}
break;
}
});

hoplon.core.vflatten.cljs$lang$maxFixedArity = 2;


/**
 * @interface
 */
hoplon.core.INode = function(){};

hoplon.core.node = (function hoplon$core$node(this$){
if((!((this$ == null))) && (!((this$.hoplon$core$INode$node$arity$1 == null)))){
return this$.hoplon$core$INode$node$arity$1(this$);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core.node[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$);
} else {
var m__7851__auto____$1 = (hoplon.core.node["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"INode.node",this$);
}
}
}
});

(hoplon.core.INode["string"] = true);

(hoplon.core.node["string"] = (function (this$){
return hoplon.core.$text.call(null,this$);
}));
(hoplon.core.INode["number"] = true);

(hoplon.core.node["number"] = (function (this$){
return hoplon.core.$text.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$)].join(''));
}));
hoplon.core.__GT_node = (function hoplon$core$__GT_node(x){
if(((!((x == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.hoplon$core$INode$)))?true:(((!x.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.INode,x):false)):cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.INode,x))){
return hoplon.core.node.call(null,x);
} else {
return x;
}
});
hoplon.core.removeChild = Element.prototype.removeChild;
hoplon.core.appendChild = Element.prototype.appendChild;
hoplon.core.insertBefore = Element.prototype.insertBefore;
hoplon.core.replaceChild = Element.prototype.replaceChild;
hoplon.core.setAttribute = Element.prototype.setAttribute;
hoplon.core.merge_kids = (function hoplon$core$merge_kids(this$,_,new$){
var new$__$1 = cljs.core.mapv.call(null,hoplon.core.__GT_node,cljs.core.reduce.call(null,(function (p1__9272_SHARP_,p2__9271_SHARP_){
if((p2__9271_SHARP_ == null)){
return p1__9272_SHARP_;
} else {
return cljs.core.conj.call(null,p1__9272_SHARP_,p2__9271_SHARP_);
}
}),cljs.core.PersistentVector.EMPTY,hoplon.core.vflatten.call(null,new$)));
var new_QMARK_ = cljs.core.set.call(null,new$__$1);
var G__9299 = new$__$1;
var vec__9301 = G__9299;
var seq__9302 = cljs.core.seq.call(null,vec__9301);
var first__9303 = cljs.core.first.call(null,seq__9302);
var seq__9302__$1 = cljs.core.next.call(null,seq__9302);
var x = first__9303;
var xs = seq__9302__$1;
var G__9300 = hoplon.core.child_vec.call(null,this$);
var vec__9304 = G__9300;
var seq__9305 = cljs.core.seq.call(null,vec__9304);
var first__9306 = cljs.core.first.call(null,seq__9305);
var seq__9305__$1 = cljs.core.next.call(null,seq__9305);
var k = first__9306;
var ks = seq__9305__$1;
var kids = vec__9304;
var G__9299__$1 = G__9299;
var G__9300__$1 = G__9300;
while(true){
var vec__9307 = G__9299__$1;
var seq__9308 = cljs.core.seq.call(null,vec__9307);
var first__9309 = cljs.core.first.call(null,seq__9308);
var seq__9308__$1 = cljs.core.next.call(null,seq__9308);
var x__$1 = first__9309;
var xs__$1 = seq__9308__$1;
var vec__9310 = G__9300__$1;
var seq__9311 = cljs.core.seq.call(null,vec__9310);
var first__9312 = cljs.core.first.call(null,seq__9311);
var seq__9311__$1 = cljs.core.next.call(null,seq__9311);
var k__$1 = first__9312;
var ks__$1 = seq__9311__$1;
var kids__$1 = vec__9310;
if(cljs.core.truth_((function (){var or__7182__auto__ = x__$1;
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return k__$1;
}
})())){
var G__9313 = xs__$1;
var G__9314 = ((cljs.core._EQ_.call(null,x__$1,k__$1))?ks__$1:((cljs.core.not.call(null,k__$1))?(function (){var ks__$2 = ks__$1;
hoplon.core.appendChild.call(this$,x__$1);

return ks__$2;
})():((cljs.core.not.call(null,x__$1))?(function (){var ks__$2 = ks__$1;
if(cljs.core.truth_(new_QMARK_.call(null,k__$1))){
} else {
hoplon.core.removeChild.call(this$,k__$1);
}

return ks__$2;
})():(function (){var kids__$2 = kids__$1;
hoplon.core.insertBefore.call(this$,x__$1,k__$1);

return kids__$2;
})()
)));
G__9299__$1 = G__9313;
G__9300__$1 = G__9314;
continue;
} else {
return null;
}
break;
}
});
hoplon.core.ensure_kids_BANG_ = (function hoplon$core$ensure_kids_BANG_(this$){
var this$__$1 = this$;
if(cljs.core.truth_(this$__$1.hoplonKids)){
} else {
var kids_9315 = cljs.core.atom.call(null,hoplon.core.child_vec.call(null,this$__$1));
this$__$1.hoplonKids = kids_9315;

hoplon.core.do_watch.call(null,kids_9315,cljs.core.partial.call(null,hoplon.core.merge_kids,this$__$1));
}

return this$__$1;
});
hoplon.core.remove_all_kids_BANG_ = (function hoplon$core$remove_all_kids_BANG_(this$){
this$.hoplonKids = null;

return hoplon.core.merge_kids.call(null,this$,null,null);
});
/**
 * Returns true if elem is a native element. Native elements' children
 *   are not managed by Hoplon.
 */
hoplon.core.native_QMARK_ = (function hoplon$core$native_QMARK_(elem){
return ((elem instanceof Element)) && ((elem.hoplonKids == null));
});
/**
 * Returns true if elem is a managed element. Managed elements have
 *   their children managed by Hoplon.
 */
hoplon.core.managed_QMARK_ = (function hoplon$core$managed_QMARK_(elem){
return cljs.core.not.call(null,hoplon.core.native_QMARK_.call(null,elem));
});
/**
 * Appends `child` to `parent` for the case of `parent` being a
 *   managed element.
 */
hoplon.core.managed_append_child = (function hoplon$core$managed_append_child(parent,child,kidfn){
var child__$1 = child;
hoplon.core.ensure_kids_BANG_.call(null,parent);

var kids_9318 = kidfn.call(null,parent);
var i_9319 = cljs.core.count.call(null,cljs.core.deref.call(null,kids_9318));
if(cljs.core.truth_(javelin.core.cell_QMARK_.call(null,child__$1))){
hoplon.core.do_watch.call(null,child__$1,((function (kids_9318,i_9319,child__$1){
return (function (p1__9317_SHARP_,p2__9316_SHARP_){
return cljs.core.swap_BANG_.call(null,kids_9318,cljs.core.assoc,i_9319,p2__9316_SHARP_);
});})(kids_9318,i_9319,child__$1))
);
} else {
cljs.core.swap_BANG_.call(null,kids_9318,cljs.core.assoc,i_9319,child__$1);
}

return child__$1;
});
hoplon.core.set_appendChild_BANG_ = (function hoplon$core$set_appendChild_BANG_(this$,kidfn){
return this$.appendChild = (function (child){
var this$__$1 = this;
if(cljs.core.truth_(child.parentNode)){
child.parentNode.removeChild(child);
} else {
}

if(cljs.core.truth_((function (){var and__7170__auto__ = hoplon.core.native_QMARK_.call(null,this$__$1);
if(cljs.core.truth_(and__7170__auto__)){
return cljs.core.not.call(null,javelin.core.cell_QMARK_.call(null,child));
} else {
return and__7170__auto__;
}
})())){
return hoplon.core.appendChild.call(this$__$1,child);
} else {
if(cljs.core.truth_((function (){var and__7170__auto__ = hoplon.core.native_QMARK_.call(null,this$__$1);
if(cljs.core.truth_(and__7170__auto__)){
return javelin.core.cell_QMARK_.call(null,child);
} else {
return and__7170__auto__;
}
})())){
return hoplon.core.managed_append_child.call(null,this$__$1,child,kidfn);
} else {
if(cljs.core.truth_(hoplon.core.managed_QMARK_.call(null,this$__$1))){
return hoplon.core.managed_append_child.call(null,this$__$1,child,kidfn);
} else {
throw cljs.core.ex_info.call(null,"Unexpected child type",new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"reason","reason",-2070751759),new cljs.core.Keyword("hoplon.core","unexpected-child-type","hoplon.core/unexpected-child-type",1756641127),new cljs.core.Keyword(null,"child","child",623967545),child,new cljs.core.Keyword(null,"native?","native?",-1916990868),hoplon.core.native_QMARK_.call(null,child),new cljs.core.Keyword(null,"managed?","managed?",-1222195407),hoplon.core.managed_QMARK_.call(null,child),new cljs.core.Keyword(null,"this","this",-611633625),this$__$1], null));

}
}
}
});
});
hoplon.core.set_removeChild_BANG_ = (function hoplon$core$set_removeChild_BANG_(this$,kidfn){
return this$.removeChild = (function (x){
var this$__$1 = this;
var x__$1 = x;
hoplon.core.ensure_kids_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),((function (x__$1,this$__$1){
return (function (p1__9320_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,cljs.core.partial.call(null,cljs.core._EQ_,x__$1),p1__9320_SHARP_));
});})(x__$1,this$__$1))
);

return x__$1;
});
});
hoplon.core.set_insertBefore_BANG_ = (function hoplon$core$set_insertBefore_BANG_(this$,kidfn){
return this$.insertBefore = (function (x,y){
var this$__$1 = this;
var x__$1 = x;
hoplon.core.ensure_kids_BANG_.call(null,this$__$1);

if(cljs.core.not.call(null,y)){
cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),cljs.core.conj,x__$1);
} else {
if(cljs.core.not_EQ_.call(null,x__$1,y)){
cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),((function (x__$1,this$__$1){
return (function (p1__9321_SHARP_){
return cljs.core.vec.call(null,cljs.core.mapcat.call(null,((function (x__$1,this$__$1){
return (function (z){
if(cljs.core._EQ_.call(null,z,y)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x__$1,z], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [z], null);
}
});})(x__$1,this$__$1))
,p1__9321_SHARP_));
});})(x__$1,this$__$1))
);
} else {
}
}

return x__$1;
});
});
hoplon.core.set_replaceChild_BANG_ = (function hoplon$core$set_replaceChild_BANG_(this$,kidfn){
return this$.replaceChild = (function (x,y){
var this$__$1 = this;
var y__$1 = y;
hoplon.core.ensure_kids_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,kidfn.call(null,this$__$1),((function (y__$1,this$__$1){
return (function (p1__9322_SHARP_){
return cljs.core.mapv.call(null,((function (y__$1,this$__$1){
return (function (z){
if(cljs.core._EQ_.call(null,z,y__$1)){
return x;
} else {
return z;
}
});})(y__$1,this$__$1))
,p1__9322_SHARP_);
});})(y__$1,this$__$1))
);

return y__$1;
});
});
hoplon.core.set_setAttribute_BANG_ = (function hoplon$core$set_setAttribute_BANG_(this$,attrfn){
return this$.setAttribute = (function (k,v){
var this$__$1 = this;
var _ = undefined;
var kk_9323 = cljs.core.keyword.call(null,k);
var attr_9324 = attrfn.call(null,this$__$1);
var has_QMARK__9325 = (function (){var and__7170__auto__ = attr_9324;
if(cljs.core.truth_(and__7170__auto__)){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,attr_9324),kk_9323);
} else {
return and__7170__auto__;
}
})();
if(cljs.core.truth_(has_QMARK__9325)){
cljs.core.swap_BANG_.call(null,attr_9324,cljs.core.assoc,kk_9323,v);
} else {
hoplon.core.setAttribute.call(this$__$1,k,v);
}

return _;
});
});
hoplon.core.set_appendChild_BANG_.call(null,Element.prototype,(function (p1__9326_SHARP_){
return p1__9326_SHARP_.hoplonKids;
}));
hoplon.core.set_removeChild_BANG_.call(null,Element.prototype,(function (p1__9327_SHARP_){
return p1__9327_SHARP_.hoplonKids;
}));
hoplon.core.set_insertBefore_BANG_.call(null,Element.prototype,(function (p1__9328_SHARP_){
return p1__9328_SHARP_.hoplonKids;
}));
hoplon.core.set_replaceChild_BANG_.call(null,Element.prototype,(function (p1__9329_SHARP_){
return p1__9329_SHARP_.hoplonKids;
}));

/**
 * @interface
 */
hoplon.core.ICustomElement = function(){};

hoplon.core._set_attributes_BANG_ = (function hoplon$core$_set_attributes_BANG_(this$,kvs){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_set_attributes_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_set_attributes_BANG_$arity$2(this$,kvs);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core._set_attributes_BANG_[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$,kvs);
} else {
var m__7851__auto____$1 = (hoplon.core._set_attributes_BANG_["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$,kvs);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-set-attributes!",this$);
}
}
}
});

hoplon.core._set_styles_BANG_ = (function hoplon$core$_set_styles_BANG_(this$,kvs){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_set_styles_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_set_styles_BANG_$arity$2(this$,kvs);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core._set_styles_BANG_[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$,kvs);
} else {
var m__7851__auto____$1 = (hoplon.core._set_styles_BANG_["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$,kvs);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-set-styles!",this$);
}
}
}
});

hoplon.core._append_child_BANG_ = (function hoplon$core$_append_child_BANG_(this$,child){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_append_child_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_append_child_BANG_$arity$2(this$,child);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core._append_child_BANG_[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$,child);
} else {
var m__7851__auto____$1 = (hoplon.core._append_child_BANG_["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$,child);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-append-child!",this$);
}
}
}
});

hoplon.core._remove_child_BANG_ = (function hoplon$core$_remove_child_BANG_(this$,child){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_remove_child_BANG_$arity$2 == null)))){
return this$.hoplon$core$ICustomElement$_remove_child_BANG_$arity$2(this$,child);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core._remove_child_BANG_[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$,child);
} else {
var m__7851__auto____$1 = (hoplon.core._remove_child_BANG_["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$,child);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-remove-child!",this$);
}
}
}
});

hoplon.core._replace_child_BANG_ = (function hoplon$core$_replace_child_BANG_(this$,new$,existing){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_replace_child_BANG_$arity$3 == null)))){
return this$.hoplon$core$ICustomElement$_replace_child_BANG_$arity$3(this$,new$,existing);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core._replace_child_BANG_[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$,new$,existing);
} else {
var m__7851__auto____$1 = (hoplon.core._replace_child_BANG_["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$,new$,existing);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-replace-child!",this$);
}
}
}
});

hoplon.core._insert_before_BANG_ = (function hoplon$core$_insert_before_BANG_(this$,new$,existing){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomElement$_insert_before_BANG_$arity$3 == null)))){
return this$.hoplon$core$ICustomElement$_insert_before_BANG_$arity$3(this$,new$,existing);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core._insert_before_BANG_[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$,new$,existing);
} else {
var m__7851__auto____$1 = (hoplon.core._insert_before_BANG_["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$,new$,existing);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomElement.-insert-before!",this$);
}
}
}
});

hoplon.core.set_attributes_BANG_ = (function hoplon$core$set_attributes_BANG_(var_args){
var args9330 = [];
var len__8295__auto___9337 = arguments.length;
var i__8296__auto___9338 = (0);
while(true){
if((i__8296__auto___9338 < len__8295__auto___9337)){
args9330.push((arguments[i__8296__auto___9338]));

var G__9339 = (i__8296__auto___9338 + (1));
i__8296__auto___9338 = G__9339;
continue;
} else {
}
break;
}

var G__9336 = args9330.length;
switch (G__9336) {
case 2:
return hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8314__auto__ = (new cljs.core.IndexedSeq(args9330.slice((3)),(0),null));
return hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8314__auto__);

}
});

hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,kvs){
return hoplon.core._set_attributes_BANG_.call(null,this$,kvs);
});

hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (this$,k,v,kvs){
return hoplon.core.set_attributes_BANG_.call(null,this$,cljs.core.apply.call(null,cljs.core.hash_map,k,v,kvs));
});

hoplon.core.set_attributes_BANG_.cljs$lang$applyTo = (function (seq9331){
var G__9332 = cljs.core.first.call(null,seq9331);
var seq9331__$1 = cljs.core.next.call(null,seq9331);
var G__9333 = cljs.core.first.call(null,seq9331__$1);
var seq9331__$2 = cljs.core.next.call(null,seq9331__$1);
var G__9334 = cljs.core.first.call(null,seq9331__$2);
var seq9331__$3 = cljs.core.next.call(null,seq9331__$2);
return hoplon.core.set_attributes_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9332,G__9333,G__9334,seq9331__$3);
});

hoplon.core.set_attributes_BANG_.cljs$lang$maxFixedArity = (3);

hoplon.core.set_styles_BANG_ = (function hoplon$core$set_styles_BANG_(var_args){
var args9341 = [];
var len__8295__auto___9348 = arguments.length;
var i__8296__auto___9349 = (0);
while(true){
if((i__8296__auto___9349 < len__8295__auto___9348)){
args9341.push((arguments[i__8296__auto___9349]));

var G__9350 = (i__8296__auto___9349 + (1));
i__8296__auto___9349 = G__9350;
continue;
} else {
}
break;
}

var G__9347 = args9341.length;
switch (G__9347) {
case 2:
return hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8314__auto__ = (new cljs.core.IndexedSeq(args9341.slice((3)),(0),null));
return hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8314__auto__);

}
});

hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,kvs){
return hoplon.core._set_styles_BANG_.call(null,this$,kvs);
});

hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (this$,k,v,kvs){
return hoplon.core.set_styles_BANG_.call(null,this$,cljs.core.apply.call(null,cljs.core.hash_map,k,v,kvs));
});

hoplon.core.set_styles_BANG_.cljs$lang$applyTo = (function (seq9342){
var G__9343 = cljs.core.first.call(null,seq9342);
var seq9342__$1 = cljs.core.next.call(null,seq9342);
var G__9344 = cljs.core.first.call(null,seq9342__$1);
var seq9342__$2 = cljs.core.next.call(null,seq9342__$1);
var G__9345 = cljs.core.first.call(null,seq9342__$2);
var seq9342__$3 = cljs.core.next.call(null,seq9342__$2);
return hoplon.core.set_styles_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9343,G__9344,G__9345,seq9342__$3);
});

hoplon.core.set_styles_BANG_.cljs$lang$maxFixedArity = (3);

hoplon.core.append_child_BANG_ = (function hoplon$core$append_child_BANG_(this$,child){
return hoplon.core._append_child_BANG_.call(null,this$,child);
});
hoplon.core.remove_child_BANG_ = (function hoplon$core$remove_child_BANG_(this$,child){
return hoplon.core._remove_child_BANG_.call(null,this$,child);
});
hoplon.core.replace_child_BANG_ = (function hoplon$core$replace_child_BANG_(this$,new$,existing){
return hoplon.core._replace_child_BANG_.call(null,this$,new$,existing);
});
hoplon.core.insert_before_BANG_ = (function hoplon$core$insert_before_BANG_(this$,new$,existing){
return hoplon.core._insert_before_BANG_.call(null,this$,new$,existing);
});

/**
 * @interface
 */
hoplon.core.ICustomAttribute = function(){};

hoplon.core._attr_BANG_ = (function hoplon$core$_attr_BANG_(this$,elem,value){
if((!((this$ == null))) && (!((this$.hoplon$core$ICustomAttribute$_attr_BANG_$arity$3 == null)))){
return this$.hoplon$core$ICustomAttribute$_attr_BANG_$arity$3(this$,elem,value);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (hoplon.core._attr_BANG_[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$,elem,value);
} else {
var m__7851__auto____$1 = (hoplon.core._attr_BANG_["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$,elem,value);
} else {
throw cljs.core.missing_protocol.call(null,"ICustomAttribute.-attr!",this$);
}
}
}
});

hoplon.core.attribute_QMARK_ = (function hoplon$core$attribute_QMARK_(this$){
if(!((this$ == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === this$.hoplon$core$ICustomAttribute$))){
return true;
} else {
if((!this$.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.ICustomAttribute,this$);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,hoplon.core.ICustomAttribute,this$);
}
});
cljs.core.Keyword.prototype.hoplon$core$ICustomAttribute$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.hoplon$core$ICustomAttribute$_attr_BANG_$arity$3 = (function (this$,elem,value){
var this$__$1 = this;
if(cljs.core.truth_(javelin.core.cell_QMARK_.call(null,value))){
return hoplon.core.do_watch.call(null,value,((function (this$__$1){
return (function (p1__9355_SHARP_,p2__9354_SHARP_){
return hoplon.core.do_BANG_.call(null,elem,this$__$1,p2__9354_SHARP_);
});})(this$__$1))
);
} else {
if(cljs.core.fn_QMARK_.call(null,value)){
return hoplon.core.on_BANG_.call(null,elem,this$__$1,value);
} else {
return hoplon.core.do_BANG_.call(null,elem,this$__$1,value);

}
}
});
hoplon.core.is_ie8 = cljs.core.not.call(null,goog.object.get(window,"Node"));
hoplon.core._head_STAR_ = ((!(hoplon.core.is_ie8))?(function (p1__9356_SHARP_){
return p1__9356_SHARP_.head;
}):(function (p1__9357_SHARP_){
return p1__9357_SHARP_.documentElement.firstChild;
}));
hoplon.core.vector_QMARK__STAR_ = ((!(hoplon.core.is_ie8))?cljs.core.vector_QMARK_:(function (p1__9358_SHARP_){
try{return cljs.core.vector_QMARK_.call(null,p1__9358_SHARP_);
}catch (e9359){if((e9359 instanceof Error)){
var _ = e9359;
return null;
} else {
throw e9359;

}
}}));
hoplon.core.seq_QMARK__STAR_ = ((!(hoplon.core.is_ie8))?cljs.core.seq_QMARK_:(function (p1__9360_SHARP_){
try{return cljs.core.seq_QMARK_.call(null,p1__9360_SHARP_);
}catch (e9361){if((e9361 instanceof Error)){
var _ = e9361;
return null;
} else {
throw e9361;

}
}}));
/**
 * Like cljs.core/nth but returns nil or not found if the index is outside the coll
 */
hoplon.core.safe_nth = (function hoplon$core$safe_nth(var_args){
var args9362 = [];
var len__8295__auto___9366 = arguments.length;
var i__8296__auto___9367 = (0);
while(true){
if((i__8296__auto___9367 < len__8295__auto___9366)){
args9362.push((arguments[i__8296__auto___9367]));

var G__9368 = (i__8296__auto___9367 + (1));
i__8296__auto___9367 = G__9368;
continue;
} else {
}
break;
}

var G__9364 = args9362.length;
switch (G__9364) {
case 2:
return hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9362.length)].join('')));

}
});

hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,index){
return hoplon.core.safe_nth.call(null,coll,index,null);
});

hoplon.core.safe_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,index,not_found){
try{return cljs.core.nth.call(null,coll,index,not_found);
}catch (e9365){if((e9365 instanceof Error)){
var _ = e9365;
return not_found;
} else {
throw e9365;

}
}});

hoplon.core.safe_nth.cljs$lang$maxFixedArity = 3;

/**
 * Executes a fuction after a delay, if no delay is passed, 0 is used as a default.
 */
hoplon.core.timeout = (function hoplon$core$timeout(var_args){
var args9370 = [];
var len__8295__auto___9373 = arguments.length;
var i__8296__auto___9374 = (0);
while(true){
if((i__8296__auto___9374 < len__8295__auto___9373)){
args9370.push((arguments[i__8296__auto___9374]));

var G__9375 = (i__8296__auto___9374 + (1));
i__8296__auto___9374 = G__9375;
continue;
} else {
}
break;
}

var G__9372 = args9370.length;
switch (G__9372) {
case 1:
return hoplon.core.timeout.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hoplon.core.timeout.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args9370.length)].join('')));

}
});

hoplon.core.timeout.cljs$core$IFn$_invoke$arity$1 = (function (f){
return hoplon.core.timeout.call(null,f,(0));
});

hoplon.core.timeout.cljs$core$IFn$_invoke$arity$2 = (function (f,t){
return window.setTimeout(f,t);
});

hoplon.core.timeout.cljs$lang$maxFixedArity = 2;

hoplon.core.when_dom = (function hoplon$core$when_dom(this$,f){
if(!((this$ instanceof Element))){
return setTimeout((function (){
return f.call(null);
}),(0));
} else {
var temp__4655__auto__ = goog.object.get(this$,"_hoplonWhenDom");
if(cljs.core.truth_(temp__4655__auto__)){
var v = temp__4655__auto__;
return v.push(f);
} else {
goog.object.set(this$,"_hoplonWhenDom",[f]);

return setTimeout(((function (temp__4655__auto__){
return (function (){
return ((function (temp__4655__auto__){
return (function hoplon$core$when_dom_$_doit(){
if(cljs.core.not.call(null,document.documentElement.contains(this$))){
return setTimeout(((function (temp__4655__auto__){
return (function (){
return hoplon$core$when_dom_$_doit.call(null);
});})(temp__4655__auto__))
,(20));
} else {
var seq__9389_9393 = cljs.core.seq.call(null,goog.object.get(this$,"_hoplonWhenDom"));
var chunk__9390_9394 = null;
var count__9391_9395 = (0);
var i__9392_9396 = (0);
while(true){
if((i__9392_9396 < count__9391_9395)){
var f_9397__$1 = cljs.core._nth.call(null,chunk__9390_9394,i__9392_9396);
f_9397__$1.call(null);

var G__9398 = seq__9389_9393;
var G__9399 = chunk__9390_9394;
var G__9400 = count__9391_9395;
var G__9401 = (i__9392_9396 + (1));
seq__9389_9393 = G__9398;
chunk__9390_9394 = G__9399;
count__9391_9395 = G__9400;
i__9392_9396 = G__9401;
continue;
} else {
var temp__4657__auto___9402 = cljs.core.seq.call(null,seq__9389_9393);
if(temp__4657__auto___9402){
var seq__9389_9403__$1 = temp__4657__auto___9402;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9389_9403__$1)){
var c__8001__auto___9404 = cljs.core.chunk_first.call(null,seq__9389_9403__$1);
var G__9405 = cljs.core.chunk_rest.call(null,seq__9389_9403__$1);
var G__9406 = c__8001__auto___9404;
var G__9407 = cljs.core.count.call(null,c__8001__auto___9404);
var G__9408 = (0);
seq__9389_9393 = G__9405;
chunk__9390_9394 = G__9406;
count__9391_9395 = G__9407;
i__9392_9396 = G__9408;
continue;
} else {
var f_9409__$1 = cljs.core.first.call(null,seq__9389_9403__$1);
f_9409__$1.call(null);

var G__9410 = cljs.core.next.call(null,seq__9389_9403__$1);
var G__9411 = null;
var G__9412 = (0);
var G__9413 = (0);
seq__9389_9393 = G__9410;
chunk__9390_9394 = G__9411;
count__9391_9395 = G__9412;
i__9392_9396 = G__9413;
continue;
}
} else {
}
}
break;
}

return goog.object.set(this$,"_hoplonWhenDom",null);
}
});})(temp__4655__auto__))
.call(null);
});})(temp__4655__auto__))
,(0));
}
}
});
hoplon.core.parse_args = (function hoplon$core$parse_args(args){
var attr = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
var kids = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
var G__9430 = args;
var vec__9431 = G__9430;
var seq__9432 = cljs.core.seq.call(null,vec__9431);
var first__9433 = cljs.core.first.call(null,seq__9432);
var seq__9432__$1 = cljs.core.next.call(null,seq__9432);
var arg = first__9433;
var args__$1 = seq__9432__$1;
var attr__$1 = attr;
var kids__$1 = kids;
var G__9430__$1 = G__9430;
while(true){
var attr__$2 = attr__$1;
var kids__$2 = kids__$1;
var vec__9434 = G__9430__$1;
var seq__9435 = cljs.core.seq.call(null,vec__9434);
var first__9436 = cljs.core.first.call(null,seq__9435);
var seq__9435__$1 = cljs.core.next.call(null,seq__9435);
var arg__$1 = first__9436;
var args__$2 = seq__9435__$1;
if(cljs.core.not.call(null,(function (){var or__7182__auto__ = arg__$1;
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return args__$2;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.persistent_BANG_.call(null,attr__$2),cljs.core.persistent_BANG_.call(null,kids__$2)], null);
} else {
if(cljs.core.map_QMARK_.call(null,arg__$1)){
var G__9437 = cljs.core.reduce_kv.call(null,((function (attr__$1,kids__$1,G__9430__$1,attr__$2,kids__$2,vec__9434,seq__9435,first__9436,seq__9435__$1,arg__$1,args__$2,attr,kids,G__9430,vec__9431,seq__9432,first__9433,seq__9432__$1,arg,args__$1){
return (function (p1__9414_SHARP_,p2__9415_SHARP_,p3__9416_SHARP_){
return cljs.core.assoc_BANG_.call(null,p1__9414_SHARP_,p2__9415_SHARP_,p3__9416_SHARP_);
});})(attr__$1,kids__$1,G__9430__$1,attr__$2,kids__$2,vec__9434,seq__9435,first__9436,seq__9435__$1,arg__$1,args__$2,attr,kids,G__9430,vec__9431,seq__9432,first__9433,seq__9432__$1,arg,args__$1))
,attr__$2,arg__$1);
var G__9438 = kids__$2;
var G__9439 = args__$2;
attr__$1 = G__9437;
kids__$1 = G__9438;
G__9430__$1 = G__9439;
continue;
} else {
if(cljs.core.truth_(hoplon.core.attribute_QMARK_.call(null,arg__$1))){
var G__9440 = cljs.core.assoc_BANG_.call(null,attr__$2,arg__$1,cljs.core.first.call(null,args__$2));
var G__9441 = kids__$2;
var G__9442 = cljs.core.rest.call(null,args__$2);
attr__$1 = G__9440;
kids__$1 = G__9441;
G__9430__$1 = G__9442;
continue;
} else {
if(cljs.core.truth_(hoplon.core.seq_QMARK__STAR_.call(null,arg__$1))){
var G__9443 = attr__$2;
var G__9444 = cljs.core.reduce.call(null,cljs.core.conj_BANG_,kids__$2,hoplon.core.vflatten.call(null,arg__$1));
var G__9445 = args__$2;
attr__$1 = G__9443;
kids__$1 = G__9444;
G__9430__$1 = G__9445;
continue;
} else {
if(cljs.core.truth_(hoplon.core.vector_QMARK__STAR_.call(null,arg__$1))){
var G__9446 = attr__$2;
var G__9447 = cljs.core.reduce.call(null,cljs.core.conj_BANG_,kids__$2,hoplon.core.vflatten.call(null,arg__$1));
var G__9448 = args__$2;
attr__$1 = G__9446;
kids__$1 = G__9447;
G__9430__$1 = G__9448;
continue;
} else {
var G__9449 = attr__$2;
var G__9450 = cljs.core.conj_BANG_.call(null,kids__$2,arg__$1);
var G__9451 = args__$2;
attr__$1 = G__9449;
kids__$1 = G__9450;
G__9430__$1 = G__9451;
continue;

}
}
}
}
}
break;
}
});
hoplon.core.add_attributes_BANG_ = (function hoplon$core$add_attributes_BANG_(this$,attr){
return cljs.core.reduce_kv.call(null,(function (p1__9453_SHARP_,p2__9452_SHARP_,p3__9454_SHARP_){
hoplon.core._attr_BANG_.call(null,p2__9452_SHARP_,p1__9453_SHARP_,p3__9454_SHARP_);

return p1__9453_SHARP_;
}),this$,attr);
});
hoplon.core.add_children_BANG_ = (function hoplon$core$add_children_BANG_(this$,p__9455){
var vec__9463 = p__9455;
var seq__9464 = cljs.core.seq.call(null,vec__9463);
var first__9465 = cljs.core.first.call(null,seq__9464);
var seq__9464__$1 = cljs.core.next.call(null,seq__9464);
var child_cell = first__9465;
var _ = seq__9464__$1;
var kids = vec__9463;
var this$__$1 = this$;
var seq__9466_9470 = cljs.core.seq.call(null,hoplon.core.vflatten.call(null,kids));
var chunk__9467_9471 = null;
var count__9468_9472 = (0);
var i__9469_9473 = (0);
while(true){
if((i__9469_9473 < count__9468_9472)){
var x_9474 = cljs.core._nth.call(null,chunk__9467_9471,i__9469_9473);
var temp__4657__auto___9475 = hoplon.core.__GT_node.call(null,x_9474);
if(cljs.core.truth_(temp__4657__auto___9475)){
var x_9476__$1 = temp__4657__auto___9475;
hoplon.core.append_child_BANG_.call(null,this$__$1,x_9476__$1);
} else {
}

var G__9477 = seq__9466_9470;
var G__9478 = chunk__9467_9471;
var G__9479 = count__9468_9472;
var G__9480 = (i__9469_9473 + (1));
seq__9466_9470 = G__9477;
chunk__9467_9471 = G__9478;
count__9468_9472 = G__9479;
i__9469_9473 = G__9480;
continue;
} else {
var temp__4657__auto___9481 = cljs.core.seq.call(null,seq__9466_9470);
if(temp__4657__auto___9481){
var seq__9466_9482__$1 = temp__4657__auto___9481;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9466_9482__$1)){
var c__8001__auto___9483 = cljs.core.chunk_first.call(null,seq__9466_9482__$1);
var G__9484 = cljs.core.chunk_rest.call(null,seq__9466_9482__$1);
var G__9485 = c__8001__auto___9483;
var G__9486 = cljs.core.count.call(null,c__8001__auto___9483);
var G__9487 = (0);
seq__9466_9470 = G__9484;
chunk__9467_9471 = G__9485;
count__9468_9472 = G__9486;
i__9469_9473 = G__9487;
continue;
} else {
var x_9488 = cljs.core.first.call(null,seq__9466_9482__$1);
var temp__4657__auto___9489__$1 = hoplon.core.__GT_node.call(null,x_9488);
if(cljs.core.truth_(temp__4657__auto___9489__$1)){
var x_9490__$1 = temp__4657__auto___9489__$1;
hoplon.core.append_child_BANG_.call(null,this$__$1,x_9490__$1);
} else {
}

var G__9491 = cljs.core.next.call(null,seq__9466_9482__$1);
var G__9492 = null;
var G__9493 = (0);
var G__9494 = (0);
seq__9466_9470 = G__9491;
chunk__9467_9471 = G__9492;
count__9468_9472 = G__9493;
i__9469_9473 = G__9494;
continue;
}
} else {
}
}
break;
}

return this$__$1;
});
Element.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

Element.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var this$__$1 = this;
return cljs.core.write_all.call(null,writer,"#<Element: ",this$__$1.tagName,">");
});

Element.prototype.cljs$core$IFn$ = cljs.core.PROTOCOL_SENTINEL;

Element.prototype.call = (function() { 
var G__9527__delegate = function (self__,args){
var self____$1 = this;
var this$ = self____$1;
var vec__9496 = hoplon.core.parse_args.call(null,args);
var attr = cljs.core.nth.call(null,vec__9496,(0),null);
var kids = cljs.core.nth.call(null,vec__9496,(1),null);
var G__9499 = this$;
hoplon.core.add_attributes_BANG_.call(null,G__9499,attr);

hoplon.core.add_children_BANG_.call(null,G__9499,kids);

return G__9499;
};
var G__9527 = function (self__,var_args){
var args = null;
if (arguments.length > 1) {
var G__9528__i = 0, G__9528__a = new Array(arguments.length -  1);
while (G__9528__i < G__9528__a.length) {G__9528__a[G__9528__i] = arguments[G__9528__i + 1]; ++G__9528__i;}
  args = new cljs.core.IndexedSeq(G__9528__a,0);
} 
return G__9527__delegate.call(this,self__,args);};
G__9527.cljs$lang$maxFixedArity = 1;
G__9527.cljs$lang$applyTo = (function (arglist__9529){
var self__ = cljs.core.first(arglist__9529);
var args = cljs.core.rest(arglist__9529);
return G__9527__delegate(self__,args);
});
G__9527.cljs$core$IFn$_invoke$arity$variadic = G__9527__delegate;
return G__9527;
})()
;

Element.prototype.apply = (function (self__,args9495){
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args9495)));
});

Element.prototype.cljs$core$IFn$_invoke$arity$2 = (function() { 
var G__9530__delegate = function (args){
var this$ = this;
var vec__9500 = hoplon.core.parse_args.call(null,args);
var attr = cljs.core.nth.call(null,vec__9500,(0),null);
var kids = cljs.core.nth.call(null,vec__9500,(1),null);
var G__9503 = this$;
hoplon.core.add_attributes_BANG_.call(null,G__9503,attr);

hoplon.core.add_children_BANG_.call(null,G__9503,kids);

return G__9503;
};
var G__9530 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9531__i = 0, G__9531__a = new Array(arguments.length -  0);
while (G__9531__i < G__9531__a.length) {G__9531__a[G__9531__i] = arguments[G__9531__i + 0]; ++G__9531__i;}
  args = new cljs.core.IndexedSeq(G__9531__a,0);
} 
return G__9530__delegate.call(this,args);};
G__9530.cljs$lang$maxFixedArity = 0;
G__9530.cljs$lang$applyTo = (function (arglist__9532){
var args = cljs.core.seq(arglist__9532);
return G__9530__delegate(args);
});
G__9530.cljs$core$IFn$_invoke$arity$variadic = G__9530__delegate;
return G__9530;
})()
;

Element.prototype.hoplon$core$ICustomElement$ = cljs.core.PROTOCOL_SENTINEL;

Element.prototype.hoplon$core$ICustomElement$_set_attributes_BANG_$arity$2 = (function (this$,kvs){
var this$__$1 = this;
var e = this$__$1;
var seq__9504 = cljs.core.seq.call(null,kvs);
var chunk__9506 = null;
var count__9507 = (0);
var i__9508 = (0);
while(true){
if((i__9508 < count__9507)){
var vec__9510 = cljs.core._nth.call(null,chunk__9506,i__9508);
var k = cljs.core.nth.call(null,vec__9510,(0),null);
var v = cljs.core.nth.call(null,vec__9510,(1),null);
var k_9533__$1 = cljs.core.name.call(null,k);
if(cljs.core._EQ_.call(null,false,v)){
e.removeAttribute(k_9533__$1);
} else {
e.setAttribute(k_9533__$1,((cljs.core._EQ_.call(null,true,v))?k_9533__$1:v));
}

var G__9534 = seq__9504;
var G__9535 = chunk__9506;
var G__9536 = count__9507;
var G__9537 = (i__9508 + (1));
seq__9504 = G__9534;
chunk__9506 = G__9535;
count__9507 = G__9536;
i__9508 = G__9537;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9504);
if(temp__4657__auto__){
var seq__9504__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9504__$1)){
var c__8001__auto__ = cljs.core.chunk_first.call(null,seq__9504__$1);
var G__9538 = cljs.core.chunk_rest.call(null,seq__9504__$1);
var G__9539 = c__8001__auto__;
var G__9540 = cljs.core.count.call(null,c__8001__auto__);
var G__9541 = (0);
seq__9504 = G__9538;
chunk__9506 = G__9539;
count__9507 = G__9540;
i__9508 = G__9541;
continue;
} else {
var vec__9513 = cljs.core.first.call(null,seq__9504__$1);
var k = cljs.core.nth.call(null,vec__9513,(0),null);
var v = cljs.core.nth.call(null,vec__9513,(1),null);
var k_9542__$1 = cljs.core.name.call(null,k);
if(cljs.core._EQ_.call(null,false,v)){
e.removeAttribute(k_9542__$1);
} else {
e.setAttribute(k_9542__$1,((cljs.core._EQ_.call(null,true,v))?k_9542__$1:v));
}

var G__9543 = cljs.core.next.call(null,seq__9504__$1);
var G__9544 = null;
var G__9545 = (0);
var G__9546 = (0);
seq__9504 = G__9543;
chunk__9506 = G__9544;
count__9507 = G__9545;
i__9508 = G__9546;
continue;
}
} else {
return null;
}
}
break;
}
});

Element.prototype.hoplon$core$ICustomElement$_set_styles_BANG_$arity$2 = (function (this$,kvs){
var this$__$1 = this;
var e = this$__$1;
var seq__9516 = cljs.core.seq.call(null,kvs);
var chunk__9517 = null;
var count__9518 = (0);
var i__9519 = (0);
while(true){
if((i__9519 < count__9518)){
var vec__9520 = cljs.core._nth.call(null,chunk__9517,i__9519);
var k = cljs.core.nth.call(null,vec__9520,(0),null);
var v = cljs.core.nth.call(null,vec__9520,(1),null);
goog.object.set(e.style,cljs.core.name.call(null,k),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join(''));

var G__9547 = seq__9516;
var G__9548 = chunk__9517;
var G__9549 = count__9518;
var G__9550 = (i__9519 + (1));
seq__9516 = G__9547;
chunk__9517 = G__9548;
count__9518 = G__9549;
i__9519 = G__9550;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9516);
if(temp__4657__auto__){
var seq__9516__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9516__$1)){
var c__8001__auto__ = cljs.core.chunk_first.call(null,seq__9516__$1);
var G__9551 = cljs.core.chunk_rest.call(null,seq__9516__$1);
var G__9552 = c__8001__auto__;
var G__9553 = cljs.core.count.call(null,c__8001__auto__);
var G__9554 = (0);
seq__9516 = G__9551;
chunk__9517 = G__9552;
count__9518 = G__9553;
i__9519 = G__9554;
continue;
} else {
var vec__9523 = cljs.core.first.call(null,seq__9516__$1);
var k = cljs.core.nth.call(null,vec__9523,(0),null);
var v = cljs.core.nth.call(null,vec__9523,(1),null);
goog.object.set(e.style,cljs.core.name.call(null,k),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join(''));

var G__9555 = cljs.core.next.call(null,seq__9516__$1);
var G__9556 = null;
var G__9557 = (0);
var G__9558 = (0);
seq__9516 = G__9555;
chunk__9517 = G__9556;
count__9518 = G__9557;
i__9519 = G__9558;
continue;
}
} else {
return null;
}
}
break;
}
});

Element.prototype.hoplon$core$ICustomElement$_append_child_BANG_$arity$2 = (function (this$,child){
var this$__$1 = this;
if(!(hoplon.core.is_ie8)){
return this$__$1.appendChild(child);
} else {
try{return this$__$1.appendChild(child);
}catch (e9526){if((e9526 instanceof Error)){
var _ = e9526;
return null;
} else {
throw e9526;

}
}}
});

Element.prototype.hoplon$core$ICustomElement$_remove_child_BANG_$arity$2 = (function (this$,child){
var this$__$1 = this;
return this$__$1.removeChild(child);
});

Element.prototype.hoplon$core$ICustomElement$_replace_child_BANG_$arity$3 = (function (this$,new$,existing){
var this$__$1 = this;
return this$__$1.replaceChild(new$,existing);
});

Element.prototype.hoplon$core$ICustomElement$_insert_before_BANG_$arity$3 = (function (this$,new$,existing){
var this$__$1 = this;
return this$__$1.insertBefore(new$,existing);
});
hoplon.core.make_singleton_ctor = (function hoplon$core$make_singleton_ctor(elem){
return (function() { 
var G__9565__delegate = function (args){
var vec__9562 = hoplon.core.parse_args.call(null,args);
var attrs = cljs.core.nth.call(null,vec__9562,(0),null);
var kids = cljs.core.nth.call(null,vec__9562,(1),null);
hoplon.core.add_attributes_BANG_.call(null,elem,attrs);

if(cljs.core.not.call(null,new cljs.core.Keyword(null,"static","static",1214358571).cljs$core$IFn$_invoke$arity$1(attrs))){
hoplon.core.remove_all_kids_BANG_.call(null,elem);

return hoplon.core.add_children_BANG_.call(null,elem,kids);
} else {
return null;
}
};
var G__9565 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9566__i = 0, G__9566__a = new Array(arguments.length -  0);
while (G__9566__i < G__9566__a.length) {G__9566__a[G__9566__i] = arguments[G__9566__i + 0]; ++G__9566__i;}
  args = new cljs.core.IndexedSeq(G__9566__a,0);
} 
return G__9565__delegate.call(this,args);};
G__9565.cljs$lang$maxFixedArity = 0;
G__9565.cljs$lang$applyTo = (function (arglist__9567){
var args = cljs.core.seq(arglist__9567);
return G__9565__delegate(args);
});
G__9565.cljs$core$IFn$_invoke$arity$variadic = G__9565__delegate;
return G__9565;
})()
;
});
hoplon.core.make_elem_ctor = (function hoplon$core$make_elem_ctor(tag){
var mkelem = (function() { 
var G__9571__delegate = function (rest__9568_SHARP_){
return cljs.core.apply.call(null,document.createElement(tag),rest__9568_SHARP_);
};
var G__9571 = function (var_args){
var rest__9568_SHARP_ = null;
if (arguments.length > 0) {
var G__9572__i = 0, G__9572__a = new Array(arguments.length -  0);
while (G__9572__i < G__9572__a.length) {G__9572__a[G__9572__i] = arguments[G__9572__i + 0]; ++G__9572__i;}
  rest__9568_SHARP_ = new cljs.core.IndexedSeq(G__9572__a,0);
} 
return G__9571__delegate.call(this,rest__9568_SHARP_);};
G__9571.cljs$lang$maxFixedArity = 0;
G__9571.cljs$lang$applyTo = (function (arglist__9573){
var rest__9568_SHARP_ = cljs.core.seq(arglist__9573);
return G__9571__delegate(rest__9568_SHARP_);
});
G__9571.cljs$core$IFn$_invoke$arity$variadic = G__9571__delegate;
return G__9571;
})()
;
if(!(hoplon.core.is_ie8)){
return mkelem;
} else {
return ((function (mkelem){
return (function() { 
var G__9574__delegate = function (args){
try{return cljs.core.apply.call(null,mkelem,args);
}catch (e9570){if((e9570 instanceof Error)){
var _ = e9570;
return cljs.core.apply.call(null,hoplon.core.make_elem_ctor.call(null,"div"),args);
} else {
throw e9570;

}
}};
var G__9574 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9575__i = 0, G__9575__a = new Array(arguments.length -  0);
while (G__9575__i < G__9575__a.length) {G__9575__a[G__9575__i] = arguments[G__9575__i + 0]; ++G__9575__i;}
  args = new cljs.core.IndexedSeq(G__9575__a,0);
} 
return G__9574__delegate.call(this,args);};
G__9574.cljs$lang$maxFixedArity = 0;
G__9574.cljs$lang$applyTo = (function (arglist__9576){
var args = cljs.core.seq(arglist__9576);
return G__9574__delegate(args);
});
G__9574.cljs$core$IFn$_invoke$arity$variadic = G__9574__delegate;
return G__9574;
})()
;
;})(mkelem))
}
});
hoplon.core.html = (function hoplon$core$html(var_args){
var args__8302__auto__ = [];
var len__8295__auto___9578 = arguments.length;
var i__8296__auto___9579 = (0);
while(true){
if((i__8296__auto___9579 < len__8295__auto___9578)){
args__8302__auto__.push((arguments[i__8296__auto___9579]));

var G__9580 = (i__8296__auto___9579 + (1));
i__8296__auto___9579 = G__9580;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((0) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((0)),(0),null)):null);
return hoplon.core.html.cljs$core$IFn$_invoke$arity$variadic(argseq__8303__auto__);
});

hoplon.core.html.cljs$core$IFn$_invoke$arity$variadic = (function (args){

return hoplon.core.add_attributes_BANG_.call(null,document.documentElement,cljs.core.nth.call(null,hoplon.core.parse_args.call(null,args),(0)));
});

hoplon.core.html.cljs$lang$maxFixedArity = (0);

hoplon.core.html.cljs$lang$applyTo = (function (seq9577){
return hoplon.core.html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq9577));
});

/**
 * Updates the document's `head` element in place.
 */
hoplon.core.head = hoplon.core.make_singleton_ctor.call(null,hoplon.core._head_STAR_.call(null,document));
/**
 * Updates the document's `body` element in place.
 */
hoplon.core.body = hoplon.core.make_singleton_ctor.call(null,document.body);
hoplon.core.a = hoplon.core.make_elem_ctor.call(null,"a");
hoplon.core.abbr = hoplon.core.make_elem_ctor.call(null,"abbr");
hoplon.core.address = hoplon.core.make_elem_ctor.call(null,"address");
hoplon.core.area = hoplon.core.make_elem_ctor.call(null,"area");
hoplon.core.article = hoplon.core.make_elem_ctor.call(null,"article");
hoplon.core.aside = hoplon.core.make_elem_ctor.call(null,"aside");
hoplon.core.audio = hoplon.core.make_elem_ctor.call(null,"audio");
hoplon.core.b = hoplon.core.make_elem_ctor.call(null,"b");
hoplon.core.base = hoplon.core.make_elem_ctor.call(null,"base");
hoplon.core.bdi = hoplon.core.make_elem_ctor.call(null,"bdi");
hoplon.core.bdo = hoplon.core.make_elem_ctor.call(null,"bdo");
hoplon.core.blockquote = hoplon.core.make_elem_ctor.call(null,"blockquote");
hoplon.core.br = hoplon.core.make_elem_ctor.call(null,"br");
hoplon.core.button = hoplon.core.make_elem_ctor.call(null,"button");
hoplon.core.canvas = hoplon.core.make_elem_ctor.call(null,"canvas");
hoplon.core.caption = hoplon.core.make_elem_ctor.call(null,"caption");
hoplon.core.cite = hoplon.core.make_elem_ctor.call(null,"cite");
hoplon.core.code = hoplon.core.make_elem_ctor.call(null,"code");
hoplon.core.col = hoplon.core.make_elem_ctor.call(null,"col");
hoplon.core.colgroup = hoplon.core.make_elem_ctor.call(null,"colgroup");
hoplon.core.data = hoplon.core.make_elem_ctor.call(null,"data");
hoplon.core.datalist = hoplon.core.make_elem_ctor.call(null,"datalist");
hoplon.core.dd = hoplon.core.make_elem_ctor.call(null,"dd");
hoplon.core.del = hoplon.core.make_elem_ctor.call(null,"del");
hoplon.core.details = hoplon.core.make_elem_ctor.call(null,"details");
hoplon.core.dfn = hoplon.core.make_elem_ctor.call(null,"dfn");
hoplon.core.dialog = hoplon.core.make_elem_ctor.call(null,"dialog");
hoplon.core.div = hoplon.core.make_elem_ctor.call(null,"div");
hoplon.core.dl = hoplon.core.make_elem_ctor.call(null,"dl");
hoplon.core.dt = hoplon.core.make_elem_ctor.call(null,"dt");
hoplon.core.em = hoplon.core.make_elem_ctor.call(null,"em");
hoplon.core.embed = hoplon.core.make_elem_ctor.call(null,"embed");
hoplon.core.fieldset = hoplon.core.make_elem_ctor.call(null,"fieldset");
hoplon.core.figcaption = hoplon.core.make_elem_ctor.call(null,"figcaption");
hoplon.core.figure = hoplon.core.make_elem_ctor.call(null,"figure");
hoplon.core.footer = hoplon.core.make_elem_ctor.call(null,"footer");
hoplon.core.form = hoplon.core.make_elem_ctor.call(null,"form");
hoplon.core.h1 = hoplon.core.make_elem_ctor.call(null,"h1");
hoplon.core.h2 = hoplon.core.make_elem_ctor.call(null,"h2");
hoplon.core.h3 = hoplon.core.make_elem_ctor.call(null,"h3");
hoplon.core.h4 = hoplon.core.make_elem_ctor.call(null,"h4");
hoplon.core.h5 = hoplon.core.make_elem_ctor.call(null,"h5");
hoplon.core.h6 = hoplon.core.make_elem_ctor.call(null,"h6");
hoplon.core.header = hoplon.core.make_elem_ctor.call(null,"header");
hoplon.core.hgroup = hoplon.core.make_elem_ctor.call(null,"hgroup");
hoplon.core.hr = hoplon.core.make_elem_ctor.call(null,"hr");
hoplon.core.i = hoplon.core.make_elem_ctor.call(null,"i");
hoplon.core.iframe = hoplon.core.make_elem_ctor.call(null,"iframe");
hoplon.core.img = hoplon.core.make_elem_ctor.call(null,"img");
hoplon.core.input = hoplon.core.make_elem_ctor.call(null,"input");
hoplon.core.ins = hoplon.core.make_elem_ctor.call(null,"ins");
hoplon.core.kbd = hoplon.core.make_elem_ctor.call(null,"kbd");
hoplon.core.keygen = hoplon.core.make_elem_ctor.call(null,"keygen");
hoplon.core.label = hoplon.core.make_elem_ctor.call(null,"label");
hoplon.core.legend = hoplon.core.make_elem_ctor.call(null,"legend");
hoplon.core.li = hoplon.core.make_elem_ctor.call(null,"li");
hoplon.core.link = hoplon.core.make_elem_ctor.call(null,"link");
hoplon.core.main = hoplon.core.make_elem_ctor.call(null,"main");
hoplon.core.html_map = hoplon.core.make_elem_ctor.call(null,"map");
hoplon.core.mark = hoplon.core.make_elem_ctor.call(null,"mark");
hoplon.core.menu = hoplon.core.make_elem_ctor.call(null,"menu");
hoplon.core.menuitem = hoplon.core.make_elem_ctor.call(null,"menuitem");
hoplon.core.html_meta = hoplon.core.make_elem_ctor.call(null,"meta");
hoplon.core.meter = hoplon.core.make_elem_ctor.call(null,"meter");
hoplon.core.multicol = hoplon.core.make_elem_ctor.call(null,"multicol");
hoplon.core.nav = hoplon.core.make_elem_ctor.call(null,"nav");
hoplon.core.noframes = hoplon.core.make_elem_ctor.call(null,"noframes");
hoplon.core.noscript = hoplon.core.make_elem_ctor.call(null,"noscript");
hoplon.core.html_object = hoplon.core.make_elem_ctor.call(null,"object");
hoplon.core.ol = hoplon.core.make_elem_ctor.call(null,"ol");
hoplon.core.optgroup = hoplon.core.make_elem_ctor.call(null,"optgroup");
hoplon.core.option = hoplon.core.make_elem_ctor.call(null,"option");
hoplon.core.output = hoplon.core.make_elem_ctor.call(null,"output");
hoplon.core.p = hoplon.core.make_elem_ctor.call(null,"p");
hoplon.core.param = hoplon.core.make_elem_ctor.call(null,"param");
hoplon.core.picture = hoplon.core.make_elem_ctor.call(null,"picture");
hoplon.core.pre = hoplon.core.make_elem_ctor.call(null,"pre");
hoplon.core.progress = hoplon.core.make_elem_ctor.call(null,"progress");
hoplon.core.q = hoplon.core.make_elem_ctor.call(null,"q");
hoplon.core.rp = hoplon.core.make_elem_ctor.call(null,"rp");
hoplon.core.rt = hoplon.core.make_elem_ctor.call(null,"rt");
hoplon.core.rtc = hoplon.core.make_elem_ctor.call(null,"rtc");
hoplon.core.ruby = hoplon.core.make_elem_ctor.call(null,"ruby");
hoplon.core.s = hoplon.core.make_elem_ctor.call(null,"s");
hoplon.core.samp = hoplon.core.make_elem_ctor.call(null,"samp");
hoplon.core.script = hoplon.core.make_elem_ctor.call(null,"script");
hoplon.core.section = hoplon.core.make_elem_ctor.call(null,"section");
hoplon.core.select = hoplon.core.make_elem_ctor.call(null,"select");
hoplon.core.shadow = hoplon.core.make_elem_ctor.call(null,"shadow");
hoplon.core.small = hoplon.core.make_elem_ctor.call(null,"small");
hoplon.core.source = hoplon.core.make_elem_ctor.call(null,"source");
hoplon.core.span = hoplon.core.make_elem_ctor.call(null,"span");
hoplon.core.strong = hoplon.core.make_elem_ctor.call(null,"strong");
hoplon.core.style = hoplon.core.make_elem_ctor.call(null,"style");
hoplon.core.sub = hoplon.core.make_elem_ctor.call(null,"sub");
hoplon.core.summary = hoplon.core.make_elem_ctor.call(null,"summary");
hoplon.core.sup = hoplon.core.make_elem_ctor.call(null,"sup");
hoplon.core.table = hoplon.core.make_elem_ctor.call(null,"table");
hoplon.core.tbody = hoplon.core.make_elem_ctor.call(null,"tbody");
hoplon.core.td = hoplon.core.make_elem_ctor.call(null,"td");
hoplon.core.template = hoplon.core.make_elem_ctor.call(null,"template");
hoplon.core.textarea = hoplon.core.make_elem_ctor.call(null,"textarea");
hoplon.core.tfoot = hoplon.core.make_elem_ctor.call(null,"tfoot");
hoplon.core.th = hoplon.core.make_elem_ctor.call(null,"th");
hoplon.core.thead = hoplon.core.make_elem_ctor.call(null,"thead");
hoplon.core.html_time = hoplon.core.make_elem_ctor.call(null,"time");
hoplon.core.title = hoplon.core.make_elem_ctor.call(null,"title");
hoplon.core.tr = hoplon.core.make_elem_ctor.call(null,"tr");
hoplon.core.track = hoplon.core.make_elem_ctor.call(null,"track");
hoplon.core.u = hoplon.core.make_elem_ctor.call(null,"u");
hoplon.core.ul = hoplon.core.make_elem_ctor.call(null,"ul");
hoplon.core.html_var = hoplon.core.make_elem_ctor.call(null,"var");
hoplon.core.video = hoplon.core.make_elem_ctor.call(null,"video");
hoplon.core.wbr = hoplon.core.make_elem_ctor.call(null,"wbr");
hoplon.core.spliced = cljs.core.vector;
hoplon.core.$text = (function hoplon$core$$text(p1__9581_SHARP_){
return document.createTextNode(p1__9581_SHARP_);
});
hoplon.core.$comment = (function hoplon$core$$comment(p1__9582_SHARP_){
return document.createComment(p1__9582_SHARP_);
});
hoplon.core._LT__BANG___ = hoplon.core.$comment;
hoplon.core.___GT_ = new cljs.core.Keyword("hoplon.core","-->","hoplon.core/-->",1031510657);
hoplon.core.add_initfn_BANG_ = (function hoplon$core$add_initfn_BANG_(f){
return window.addEventListener("load",(function (){
return setTimeout((function (){
return f.call(null);
}),(0));
}));
});
hoplon.core.page_load = (function hoplon$core$page_load(){
return document.dispatchEvent("page-load");
});
hoplon.core.on_page_load = (function hoplon$core$on_page_load(f){
return document.addEventListener("page-load",f);
});
hoplon.core.add_initfn_BANG_.call(null,(function (){
return document.body.addEventListener("submit",(function (p1__9583_SHARP_){
var e = p1__9583_SHARP_.target;
if(cljs.core.truth_((function (){var or__7182__auto__ = e.getAttribute("action");
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return e.getAttribute("method");
}
})())){
return null;
} else {
return p1__9583_SHARP_.preventDefault();
}
}));
}));
if(typeof hoplon.core.do_BANG_ !== 'undefined'){
} else {
hoplon.core.do_BANG_ = (function (){var method_table__8115__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8116__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8117__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8118__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8119__auto__ = cljs.core.get.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365)], null),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hoplon.core","do!"),((function (method_table__8115__auto__,prefer_table__8116__auto__,method_cache__8117__auto__,cached_hierarchy__8118__auto__,hierarchy__8119__auto__){
return (function (elem,key,val){
var temp__4655__auto__ = cljs.core.namespace.call(null,key);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return cljs.core.keyword.call(null,n,"*");
} else {
return key;
}
});})(method_table__8115__auto__,prefer_table__8116__auto__,method_cache__8117__auto__,cached_hierarchy__8118__auto__,hierarchy__8119__auto__))
,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),hierarchy__8119__auto__,method_table__8115__auto__,prefer_table__8116__auto__,method_cache__8117__auto__,cached_hierarchy__8118__auto__));
})();
}
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),(function (elem,key,val){
return hoplon.core.do_BANG_.call(null,elem,new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.PersistentArrayMap.createAsIfByAssoc([key,val]));
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("css","*","css/*",-1295355419),(function (elem,key,val){
return hoplon.core.set_styles_BANG_.call(null,elem,key,val);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("html","*","html/*",-1283138243),(function (elem,key,val){
return hoplon.core.set_attributes_BANG_.call(null,elem,key,val);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword("svg","*","svg/*",-1295405562),(function (elem,key,val){
return hoplon.core.set_attributes_BANG_.call(null,elem,key,val);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword(null,"attr","attr",-604132353),(function (elem,_,kvs){
return hoplon.core.set_attributes_BANG_.call(null,elem,kvs);
}));
cljs.core._add_method.call(null,hoplon.core.do_BANG_,new cljs.core.Keyword(null,"css","css",1135045163),(function (elem,_,kvs){
return hoplon.core.set_styles_BANG_.call(null,elem,kvs);
}));
if(typeof hoplon.core.on_BANG_ !== 'undefined'){
} else {
hoplon.core.on_BANG_ = (function (){var method_table__8115__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8116__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8117__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8118__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8119__auto__ = cljs.core.get.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365)], null),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hoplon.core","on!"),((function (method_table__8115__auto__,prefer_table__8116__auto__,method_cache__8117__auto__,cached_hierarchy__8118__auto__,hierarchy__8119__auto__){
return (function (elem,key,val){
var temp__4655__auto__ = cljs.core.namespace.call(null,key);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return cljs.core.keyword.call(null,n,"*");
} else {
return key;
}
});})(method_table__8115__auto__,prefer_table__8116__auto__,method_cache__8117__auto__,cached_hierarchy__8118__auto__,hierarchy__8119__auto__))
,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),hierarchy__8119__auto__,method_table__8115__auto__,prefer_table__8116__auto__,method_cache__8117__auto__,cached_hierarchy__8118__auto__));
})();
}
cljs.core._add_method.call(null,hoplon.core.on_BANG_,new cljs.core.Keyword("hoplon.core","default","hoplon.core/default",-778824365),(function (elem,event,callback){
return hoplon.core.when_dom.call(null,elem,(function (){
return elem.addEventListener(cljs.core.name.call(null,event),callback);
}));
}));
cljs.core._add_method.call(null,hoplon.core.on_BANG_,new cljs.core.Keyword("html","*","html/*",-1283138243),(function (elem,event,callback){
return hoplon.core.when_dom.call(null,elem,(function (){
return elem.addEventListener(cljs.core.name.call(null,event),callback);
}));
}));
/**
 * Given a cell items containing a seqable collection, constructs a cell that
 *   works like a fill vector. The template tpl is a function of one argument: the
 *   formula cell containing the ith item in items. The tpl function is called
 *   once (and only once) for each index in items. When the items collection
 *   shrinks the DOM element created by the template is not destroyed--it is only
 *   removed from the DOM and cached. When the items collection grows again those
 *   cached elements will be reinserted into the DOM at their original index.
 */
hoplon.core.loop_tpl_STAR_ = (function hoplon$core$loop_tpl_STAR_(items,tpl){
var on_deck = cljs.core.atom.call(null,cljs.core.List.EMPTY);
var items_seq = javelin.core.formula.call(null,((function (on_deck){
return (function (G__9595,G__9596){
return G__9595.call(null,G__9596);
});})(on_deck))
).call(null,cljs.core.seq,items);
var ith_item = ((function (on_deck,items_seq){
return (function (p1__9584_SHARP_){
return javelin.core.formula.call(null,((function (on_deck,items_seq){
return (function (G__9598,G__9599,G__9597){
return G__9597.call(null,G__9598,G__9599);
});})(on_deck,items_seq))
).call(null,items_seq,p1__9584_SHARP_,hoplon.core.safe_nth);
});})(on_deck,items_seq))
;
var shift_BANG_ = ((function (on_deck,items_seq,ith_item){
return (function (p1__9585_SHARP_){
var x = cljs.core.first.call(null,cljs.core.deref.call(null,p1__9585_SHARP_));
cljs.core.swap_BANG_.call(null,p1__9585_SHARP_,cljs.core.rest);

return x;
});})(on_deck,items_seq,ith_item))
;
var current = javelin.core.cell.call(null,cljs.core.PersistentVector.EMPTY);
hoplon.core.do_watch.call(null,items_seq,((function (current,on_deck,items_seq,ith_item,shift_BANG_){
return (function (old_items,new_items){
var old = cljs.core.count.call(null,old_items);
var new$ = cljs.core.count.call(null,new_items);
var diff = (new$ - old);
if((diff > (0))){
var seq__9600 = cljs.core.seq.call(null,cljs.core.range.call(null,old,new$));
var chunk__9601 = null;
var count__9602 = (0);
var i__9603 = (0);
while(true){
if((i__9603 < count__9602)){
var i = cljs.core._nth.call(null,chunk__9601,i__9603);
var e_9604 = (function (){var or__7182__auto__ = shift_BANG_.call(null,on_deck);
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return tpl.call(null,ith_item.call(null,i));
}
})();
cljs.core.swap_BANG_.call(null,current,cljs.core.conj,e_9604);

var G__9605 = seq__9600;
var G__9606 = chunk__9601;
var G__9607 = count__9602;
var G__9608 = (i__9603 + (1));
seq__9600 = G__9605;
chunk__9601 = G__9606;
count__9602 = G__9607;
i__9603 = G__9608;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9600);
if(temp__4657__auto__){
var seq__9600__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9600__$1)){
var c__8001__auto__ = cljs.core.chunk_first.call(null,seq__9600__$1);
var G__9609 = cljs.core.chunk_rest.call(null,seq__9600__$1);
var G__9610 = c__8001__auto__;
var G__9611 = cljs.core.count.call(null,c__8001__auto__);
var G__9612 = (0);
seq__9600 = G__9609;
chunk__9601 = G__9610;
count__9602 = G__9611;
i__9603 = G__9612;
continue;
} else {
var i = cljs.core.first.call(null,seq__9600__$1);
var e_9613 = (function (){var or__7182__auto__ = shift_BANG_.call(null,on_deck);
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return tpl.call(null,ith_item.call(null,i));
}
})();
cljs.core.swap_BANG_.call(null,current,cljs.core.conj,e_9613);

var G__9614 = cljs.core.next.call(null,seq__9600__$1);
var G__9615 = null;
var G__9616 = (0);
var G__9617 = (0);
seq__9600 = G__9614;
chunk__9601 = G__9615;
count__9602 = G__9616;
i__9603 = G__9617;
continue;
}
} else {
return null;
}
}
break;
}
} else {
if((diff < (0))){
var n__8105__auto__ = (- diff);
var _ = (0);
while(true){
if((_ < n__8105__auto__)){
var e_9618 = cljs.core.peek.call(null,cljs.core.deref.call(null,current));
cljs.core.swap_BANG_.call(null,current,cljs.core.pop);

cljs.core.swap_BANG_.call(null,on_deck,cljs.core.conj,e_9618);

var G__9619 = (_ + (1));
_ = G__9619;
continue;
} else {
return null;
}
break;
}
} else {
return null;
}
}
});})(current,on_deck,items_seq,ith_item,shift_BANG_))
);

return current;
});
/**
 * Defines a cell whose value is the URI fragment.
 */
hoplon.core.route_cell = (function hoplon$core$route_cell(var_args){
var args__8302__auto__ = [];
var len__8295__auto___9628 = arguments.length;
var i__8296__auto___9629 = (0);
while(true){
if((i__8296__auto___9629 < len__8295__auto___9628)){
args__8302__auto__.push((arguments[i__8296__auto___9629]));

var G__9630 = (i__8296__auto___9629 + (1));
i__8296__auto___9629 = G__9630;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((0) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((0)),(0),null)):null);
return hoplon.core.route_cell.cljs$core$IFn$_invoke$arity$variadic(argseq__8303__auto__);
});

hoplon.core.route_cell.cljs$core$IFn$_invoke$arity$variadic = (function (p__9621){
var vec__9622 = p__9621;
var default$ = cljs.core.nth.call(null,vec__9622,(0),null);
var c = javelin.core.cell.call(null,window.location.hash);
var _ = javelin.core.formula.call(null,((function (c,vec__9622,default$){
return (function (G__9625,G__9627,G__9626){
var or__7182__auto__ = (function (){var and__7170__auto__ = G__9625.call(null,G__9626);
if(cljs.core.truth_(and__7170__auto__)){
return G__9626;
} else {
return and__7170__auto__;
}
})();
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return G__9627;
}
});})(c,vec__9622,default$))
).call(null,cljs.core.seq,default$,c);
window.addEventListener("hashchange",((function (_,c,vec__9622,default$){
return (function (){
return cljs.core.reset_BANG_.call(null,c,window.location.hash);
});})(_,c,vec__9622,default$))
);

return _;
});

hoplon.core.route_cell.cljs$lang$maxFixedArity = (0);

hoplon.core.route_cell.cljs$lang$applyTo = (function (seq9620){
return hoplon.core.route_cell.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq9620));
});


//# sourceMappingURL=core.js.map