(ns feathers.client
  (:require ["@feathersjs/client" :as client]))

(def client feathers)

(defn configure
  [app callback]
  (.configure app callback))

(defn jquery [app uri jquery]
  (configure app (.jquery (client/rest uri) jquery)))

(defn request [app uri request]
  (configure app (.request (client/rest uri) request)))

(defn socketio [app socket]
  (doto app
    (configure (client/socketio socket))))

(defn authentication [app conf]
  (doto app
    (configure (client/authentication conf))))

(defn service
  [app svc]
  (.service app svc))

(defn authenticate
  ([app] (.authenticate app))
  ([app conf] (.authenticate app conf)))

(defn reauthenticate [app]
  (.reAuthenticate app))

(defn logout
  [app]
  (.logout app))
