(ns feathers.boot-feathers
  (:require [boot.core :as boot]
            [degree9.boot-npm :as npm]))

(boot/deftask feathers
  "Download feathers.js npm packages."
  []
  (npm/npm :install
    ["feathers" "feathers-rest" "feathers-socketio" "feathers-errors" "feathers-memory" "feathers-hooks"]
    {                           (:feathers                  *opts* "latest")
                           (:rest                      *opts* "latest")
                       (:socketio                  *opts* "latest"
                         (:errors                    *opts* "latest")
                         (:memory                    *opts* "latest"
                          (:hooks                     *opts* "latest")))
     "feathers-configuration"             (:configuration             *opts* "latest")
     "body-parser"                        (:body-parser               *opts* "latest")
     "cors"                               (:cors                      *opts* "latest")
     "compression"                        (:compression               *opts* "latest")
     "serve-favicon"                      (:serve-favicon             *opts* "latest")
     "feathers-authentication"            (:authentication            *opts* "latest")
     "feathers-authentication-jwt"        (:authentication-jwt        *opts* "latest")
     "feathers-authentication-local"      (:authentication-local      *opts* "latest")
     "feathers-authentication-oauth1"     (:authentication-oauth1     *opts* "latest")
     "feathers-authentication-oauth2"     (:authentication-oauth2     *opts* "latest")
     "feathers-authentication-management" (:authentication-management *opts* "latest")}
    :cache-key ::feathers))
