(ns feathers.hooks
  (:refer-clojure :exclude [remove])
  (:require [cljs.nodejs :as node]
            [feathers.core :as fs]))

(def hooks (node/require "feathers-hooks"))

(def common (node/require "feathers-hooks-common"))

(defn configure [app]
  (fs/configure app (hooks)))

(defn remove [field]
  (.remove common field))

(defn disallow [field]
  (.disallow common field))
