(ns degree9.ui.table
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.button :as button]
            [uikit-hl.table :as table]))

(h/defelem table [{:keys [button headers cells data] :as attr} kids]
  (table/table (dissoc attr :headers)
    (table/header
      (table/row
        (h/for-tpl [h headers]
          (table/hcell h))))
    (table/body
      (h/for-tpl [d data]
        (table/row
          (for [c cells]
            (let []
              (j/cell= (prn c))
              (table/cell
                (cond
                  (keyword? c) (h/text "~{(c d)}")
                  (f? c) (c d)
                  :else c)))))))))
          ; (h/when-tpl button
          ;   (let [{:keys [click label] :as attr} button]
          ;     (table/cell
          ;       (button/button
          ;         (dissoc attr :click)
          ;         :click (partial click @d)
          ;         label)))))))))
