(ns degree9.ui.modal
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.core :as uk]
            [uikit-hl.close :as close]
            [uikit-hl.modal :as modal]))

(defprotocol IModal
  (show! [modal] [modal opts] "Shows a modal.")
  (hide! [modal] [modal opts] "Hides a modal."))

(extend-type js/Element
  IModal
  (show!
    ([modal] (show! modal {}))
    ([modal opts] (modal/show (uk/modal modal opts))))
  (hide!
    ([modal] (hide! modal {}))
    ([modal opts] (modal/hide (uk/modal modal opts)))))

(h/defelem close [{:keys [large] :as attr} _]
  (modal/close
    (dissoc attr :large)
    ::close/large large))

(h/defelem modal [{:keys [center container full outside header title body footer] :as attr} kids]
  (let [default (j/cell= (not (or full outside)))]
    (modal/modal :container container :full full
      (modal/dialog ::margin/auto-vertical center
        (h/when-tpl close
          (j/cell-let []
            (modal/close :outside outside :full full :default default)))
        (h/if-tpl title (modal/header title) header)
        (h/if-tpl body body kids)
        (h/when-tpl footer footer)))))
