(ns degree9.ui.modal
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.core :as uk]
            [uikit-hl.modal :as modal]))

(defprotocol IModal
  (show! [modal] [modal opts] "Shows a modal.")
  (hide! [modal] [modal opts] "Hides a modal."))

(extend-type js/Element
  IModal
  (show!
    ([modal] (show! modal {}))
    ([modal opts] (modal/show (uk/modal modal opts))))
  (hide!
    ([modal] (hide! modal {}))
    ([modal opts] (modal/hide (uk/modal modal opts)))))

(h/defelem modal [{:keys [container full close outside header title body footer] :as attr} kids]
  (modal/modal :container container :full full
    (modal/dialog
      (h/when-tpl close
        (modal/close :outside outside :full full
          :default (j/cell= (not (or full outside)))))
      (h/when-tpl (j/cell= (or header title))
        (modal/header
          (h/if-tpl title
            (modal/title (h/text "~{title}")) 
            header)))
      (h/if-tpl body
        (modal/body body)
        kids)
      (h/when-tpl footer
        (modal/footer footer)))))
