(ns degree9.ui.height
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [degree9.object :as obj]
            [uikit-hl.height :as height]
            [uikit-hl.utility :as util]))

(defn- dimensions [el]
  (.getBoundingClientRect el))

(defn- window-height [win]
  (.-innerHeight win))

(defn- document-height [el]
  (let [doc el.documentElement]
    (max (.-offsetHeight doc) (.-scrollHeight doc))))

(defn- style [el style]
  (obj/get (.-style el) style))

(defn- element-height [el]
  (let [current (style el :height)]
    (if (= "auto" current)
        (style el :offsetHeight)
        current)))

(defn- height [el]
  (cond
    (= js/window el)   (window-height el)
    (= js/document el) (document-height el)
    :else              (element-height el)))

(defmethod h/do! :expand-height
  [elem kw v]
  ;; formula to calculate height
  ;; window height - (offset document height - offset current element height ) - box model adjustment
  (let [win (height js/window)
        doc (height js/document)
        current (height elem)]
    (prn win doc current)))
    ;(obj/set elem.style.minHeight (- win (- doc current)))))

(h/defelem viewport [attr kids]
  (util/panel
    attr
    ::height/viewport {:expand true}
    kids))
