(ns degree9.ui.height
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [degree9.object :as obj]
            [uikit-hl.height :as height]
            [uikit-hl.utility :as util]))

(defn- dimensions [el]
  (.getBoundingClientRect el))

(defn- inner-height [el]
  (.-innerHeight el))

(defn- max-height [el]
  (max (.-offsetHeight el) (.-scrollHeight el)))

(defn- height [el]
  (cond
    (= js/window el)   (inner-height el)
    (= js/document el) (max-height el.documentElement)))

(defmethod h/do! :expand-height
  [elem kw v]
  ;; formula to calculate height
  ;; window height - (offset document height - offset current element height ) - box model adjustment
  (let [win (.-innerHeight js/window)
        doc (.-height js/document.documentElement)
        current (.-height elem.style)]
    (prn win doc current)))
    ;(obj/set elem.style.minHeight (- win (- doc current)))))

(h/defelem viewport [attr kids]
  (util/panel
    attr
    ::height/viewport {:expand true}
    kids))
