(ns degree9.ui.height
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [degree9.object :as obj]
            [uikit-hl.height :as height]
            [uikit-hl.utility :as util]))

(defmethod h/do! ::expand
  [elem kw v]
  ;; formula to calculate height
  ;; window height - (offset document height - offset current element height ) - box model adjustment
  (let [win (.-innerHeight js/window)
        doc (.-height js/document.documentElement)
        current (.-height elem.style)]
    (obj/set elem.style.minHeight (- win (- doc current)))))

(h/defelem viewport [attr kids]
  (util/panel
    attr
    ::height/viewport {:expand true}
    kids))
