(ns degree9.ui.breadcrumb
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.breadcrumb :as breadcrumb]))

(h/defelem item [{:keys [active] :as attr} kids]
  (breadcrumb/item
    (h/if-tpl active
      (h/span attr kids)
      (h/h attr kids))))

(h/defelem breadcrumb [{:keys [items] :as attr} kids]
  (breadcrumb/breadcrumb attr kids
    (h/for-tpl [{:keys [active label]} items]
      (item :active active (h/text "~{label}")))))
