(ns degree9.ui
  (:require-macros degree9.ui)
  (:require [hoplon.core :as h]))

(defn stylesheet [url]
  (h/link :rel "stylesheet" :href url))

(defn script [url]
  (h/script :src url :type "text/javascript" :async true :defer true))

(defn map-scripts [scripts]
  (map script scripts))

(defn map-stylesheets [styles]
  (map stylesheet styles))

(h/defelem application [{:keys [styles scripts] :as attr} kids]
  (h/html
    (h/head
      (map-stylesheets styles)
      (map-scripts scripts)
      (font-awesome))
    (h/body :css {:background "#f9f9fb"}
      (auth/if-auth
        (dashboard :version version :icon icon :menu menu :toolbar toolbar
          kids)
        (authui/authenticate :icon icon)))))
