(ns degree9.ui
  (:require-macros degree9.ui)
  (:require [hoplon.core :as h]))

(defn stylesheet [url]
  (h/link :rel "stylesheet" :href url))

(defn map-styles [styles]
  (map stylesheet styles))

(defn map-scripts [styles]
  (map scripts styles))


(h/defelem application [{:keys [styles] :as attr} kids]
  (h/html
    (h/head
      (map-styles styles)
      (map-scripts scripts)
      (font-awesome))
    (h/body :css {:background "#f9f9fb"}
      (auth/if-auth
        (dashboard :version version :icon icon :menu menu :toolbar toolbar
          kids)
        (authui/authenticate :icon icon)))))
