(ns degree9.ui.modals
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.button :as button]
            [uikit-hl.modal :as modal]))

(defn show! [elem & [opts]]
  (modal/show! (modal/modal! elem (clj->js (or opts {})))))

(h/defelem modal [{:keys [close outside default header body footer] :as attr} kids]
  (modal/modal
    (modal/dialog
      (h/when-tpl close (modal/close :outside outside :default default))
      (h/if-tpl body
        (modal/body body)
        kids))))
