(ns degree9.ui.cards
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.card :as card]
            [uikit-hl.padding :as padding]))

(def title card/title)

(h/defelem card [{:keys [header body footer] :as attr} kids]
  (card/card
    (dissoc attr :header :body :footer)
    (h/when-tpl header
      (card/header header))
    (h/if-tpl body
      (card/body ::padding/remove true body)
      kids)
    (h/when-tpl footer
      (card/footer footer))))
