(ns degree9.ui.tables
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.button :as button]
            [uikit-hl.table :as table]))

(h/defelem header [{:keys [headers] :as attr} kids]
  (table/header
    (table/row
      (h/for-tpl [h headers]
        (table/hcell (h/text h)))
      (table/hcell ::table/shrink true))))

(h/defelem row [{:keys [button label cells data] :as attr} kids]
  (table/row
    (h/for-tpl [c cells]
      (table/cell (h/text "~{(get-in data (if (keyword? c) [c] c))}")))
    (table/cell
      (button/button button label))))

(h/defelem table [{:keys [button label headers cells data] :as attr} kids]
  (table/table (dissoc attr :headers)
    (header :headers headers)
    (table/body
      (h/for-tpl [d data]
        (table/row :button button :label label :cells cells :data data)))))
