(ns degree9.ui.tables
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.button :as button]
            [uikit-hl.table :as table]))

(h/defelem header [attr kids]
  (table/header
    (table/row
      (h/for-tpl [k kids]
        (table/hcell (h/text k)))
      (table/hcell ::table/shrink true))))

(h/defelem table [{:keys [button label headers cells data] :as attr} kids]
  (table/table (dissoc attr :headers)
    (header headers)
    (table/body
      (h/for-tpl [d data]
        (table/row
          (h/for-tpl [c cells]
            (table/cell (h/text "~{(get-in d c)}")))
          (table/cell
            (button/button button label)))))))
