(ns degree9.ui.tables
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.button :as button]
            [uikit-hl.table :as table]))

(h/defelem table [{:keys [button headers cells] :as attr} kids]
  (table/table (dissoc attr :headers)
    (table/header
      (table/row
        (h/for-tpl [h headers]
          (table/hcell (h/text h)))
        (table/hcell :class [:uk-table-shrink])))
    (table/body
      (h/for-tpl [data data]
        (table/row
          (h/for-tpl [cell cells]
            (table/cell (h/text cell)))
          (table/cell
            (button/button button (:text button))))))))
