(ns degree9.ui.tables
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.button :as button]
            [uikit-hl.table :as table]))

(h/defelem list-physicians [{:keys [header] :as attr} kids]
  (table/table
    :striped true
    :middle true
    (table/header
      (table/row
        (h/for-tpl [h header]
          (table/hcell (h/text h)))
        (table/hcell :class [:uk-table-shrink])))
    (table/body
      (h/for-tpl [physician data]
        (table/row
          (table/cell (h/text "~{(:first-name physician)} ~{(:last-name physician)}"))
          (table/cell
            (button/button :click #(action! @physician) :default true action)))))))
