(ns degree9.ui.tables
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [uikit-hl.button :as button]
            [uikit-hl.table :as table]))

(table/table
  :striped true
  :middle true
  (table/header
    (table/row
      (table/hcell "First Name")
      (table/hcell "Last Name")
      (table/hcell :class [:uk-table-shrink])))
  (table/body
    (h/for-tpl [physician data]
      (table/row
        (table/cell (h/text "~{(:first-name physician)} ~{(:last-name physician)}"))
        (table/cell
          (button/button :click #(action! @physician) :default true action))))))
