(ns degree9.url
  (:require [degree9.browser :as bom]
            [degree9.object :as obj]))

(defn create-url
  ([] (create-url (bom/location js/window)))
  ([location] (js/URL. location)))

(defn create-search-params
  ([] (create-search-params (:search (bom/location js/window))))
  ([search] (js/URLSearchParams. search)))

(defn search->clj [search]
  (let [entries (:entries search)]
    (js->clj (obj/from-entries entries))))

(defn clj->search [data]
  (js/URLSearchParams. (clj->js data)))

;; URLSearchParams Protocols ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(extend-type js/URLSearchParams
  ILookup
  (-lookup
   ([o k] (.get o (name k)))
   ([o k default] (or (.get o (name k)) default))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
