(ns degree9.browser
  (:require [degree9.object :as obj]))

(defprotocol IWindow
  "Interface for interacting with Browser Window."
  (navigator [this] "Returns a reference to the navigator object."))

(extend-protocol IWindow
  js/Window
  (navigator [this] (.-navigator this)))

(defn get-window []
  js/window)

(defn get-document []
  (:document (get-window)))

(defn get-location []
  (:location (get-window)))

(defn get-history []
  (:history (get-window)))

(defn get-navigator []
  (:navigator (get-window)))

(defn local-storage []
  (:localStorage (get-window)))

(defn session-storage []
  (:sessionStorage (get-window)))

(defn indexed-db []
  (:indexedDB (get-window)))
