(ns degree9.browser.indexed-db.objectstore)

(defprotocol IDBObjectStore
  (indexNames [this] "List the names of indexes on objects in this object store.")
  (keyPath [this] "The key path of this object store.")
  (name [this] "The name of this object store.")
  (transaction [this] "The IDBTransaction object to which this object store belongs.")
  (autoIncrement [this] "The value of the auto increment flag for this object store.")
  (add [this value] [this value key] "Add new records to an object store.")
  (clear [this] "Delete all current records out of an object store.")
  (count [this] [this query] "Return the total number of records in the store.")
  (createIndex
    [this indexName keyPath] [this indexName keyPath objectParameters]
    "Create a new index during a version upgrade.")
  (delete [this key] "Delete individual records out of an object store.")
  (deleteIndex [this indexName] "Destroys the specified index during a version upgrade.")
  (get [this key] "Return specific records from an object store.")
  (getKey [this key] "Return the record key for the object in the object stored matching the specified parameter.")
  (getAll [this] [this query] [this query count] "Returns all objects in the object store matching the specified parameter or all objects.")
  (getAllKeys [this] [this query] [this query count] "Returns all objects in the object store matching the specified parameter or all objects.")
  (index [this name] "Opens an index from this object store.")
  (openCursor [this] "Used for iterating through an object store by primary key with a cursor.")
  (openKeyCursor [this] "Used for iterating through an object store with a key.")
  (put [this] "This is for updating existing records in an object store when the transaction's mode is readwrite.")
  (onerror [this callback] "Handle errors on the object store.")
  (onsuccess [this callback] "Handle success on the object store."))

(extend-type js/IDBObjectStore
  IDBObjectStore
  (indexNames [this]
    (.-indexNames this))
  (keyPath [this]
    (.-keyPath this))
  (name [this]
    (.-name this))
  (transaction [this]
    (.-transaction this))
  (autoIncrement [this]
    (.-autoIncrement this))
  (onerror [this callback]
    (.addEventListener this "error" callback))
  (onsuccess [this callback]
    (.addEventListener this "success" callback)))
