(ns degree9.browser.indexed-db.objectstore)

(defprotocol IDBObjectStore
  (indexNames [this] "")
  (keyPath [this] "")
  (name [this] "")
  (transaction [this] "")
  (autoIncrement [this] "")
  (add [this value] [this value key] "Add new records to an object store.")
  (clear [this] "Delete all current records out of an object store.")
  (count [this] "")
  (add [this] "")
  (createIndex [this] "")
  (delete [this] "")
  (deleteIndex [this] "")
  (get [this] "")
  (getKey [this] "")
  (getAll [this] "")
  (getAllKeys [this] "")
  (index [this] "")
  (openCursor [this] "")
  (openKeyCursor [this] "")
  (put [this] "")
  (onerror [this callback] "Handle errors on the open database request.")
  (onsuccess [this callback] "Handle success on the open database request."))

(extend-type js/IDBObjectStore
  IDBObjectStore
  (indexNames [this]
    (.-indexNames this))
  (keyPath [this]
    (.-keyPath this))
  (name [this]
    (.-name this))
  (transaction [this]
    (.-transaction this))
  (autoIncrement [this]
    (.-autoIncrement this))
  (onerror [this callback]
    (.addEventListener this "error" callback))
  (onsuccess [this callback]
    (.addEventListener this "success" callback)))
