(ns degree9.routing
  (:require [goog.events :as events]
            [goog.dom :as dom]
            [javelin.core :as j]
            [degree9.object :as obj]
            [degree9.string :as str])
  (:require-macros degree9.routing)
  (:import [goog.history Event EventType]))

;; Window History Object ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def ^:dynamic *history* (.-history js/window))

(defn- state-cell []
  (let [history (j/cell (.-state *history*))]
    (j/with-let [history= (j/cell= history (fn [state] (reset! history state)))]
      (events/listen js/window EventType.NAVIGATE
        (fn [event] (.log js/console "state-cell" event) (reset! history= (.-state event)))))))

(def state (state-cell))

(j/cell= (.log js/console "state" state))

(defn- url-cell []
  (let [url (j/cell (js/URL. (.. js/window -location)))]
    (j/with-let [url= (j/cell= url (fn [loc] (reset! url (js/URL. loc))))]
      (events/listen js/window EventType.NAVIGATE
        (fn [event] (.log js/console "url-cell" event) (reset! url= (.. js/window -location)))))))

(def url (url-cell))

(j/cell= (.log js/console "url" url))

(defn- search->clj [search]
  (let [entries (.entries search)]
    (js->clj (obj/from-entries entries))))

(defn- clj->search [data]
  (js/URLSearchParams. (clj->js data)))

(defn- search-cell []
  (let [params (j/cell (js/URLSearchParams. (.. js/window -location -search)))]
    (j/with-let [params= (j/cell= params (fn [search] (reset! params (js/URLSearchParams. search))))]
      (events/listen js/window EventType.NAVIGATE
        (fn [event] (.log js/console "search-cell" event) (reset! params= (.. js/window -location -search)))))))

(def search (search-cell))

(j/cell= (.log js/console "search" search))

(defn- path-cell []
  (let [url (js/URL. (.. js/window -location))
        path (j/cell (.-pathname url))]
    (j/with-let [path= (j/cell= path (fn [loc] (reset! path (.-pathname loc))))]
      (events/listen js/window EventType.NAVIGATE
        (fn [event] (.log js/console "path-cell" event) (reset! path= (.. js/window -location)))))))

(def path (path-cell))

(j/cell= (.log js/console "path" path))

(defn- push! [state title path]
  (.pushState *history* state title path))

(defn- replace! [state title path]
  (.replaceState *history* state title path))

(defn- popstate! [state]
  (.dispatchEvent js/window (js/PopStateEvent. "popstate" (clj->js {:state state}))))

; (defn mkhistory [{:keys [prefix fragment transformer]}]
;    (if (Html5History.isSupported)
;      (doto (Html5History. nil transformer)
;        (.setPathPrefix  prefix)
;        (.setUseFragment fragment))
;      (History.)))
;
; (defn history-cell [& [opts]]
;   (let [history  (mkhistory opts)
;         historyc (j/cell (.getToken history))]
;    (j/with-let [_ (j/cell= historyc (fn [token] (.setToken history token)))]
;      (events/listen history EventType.NAVIGATE
;        (fn [event] (reset! historyc (.-token event))))
;      (.setEnabled history true))))
;
; (def transformer
;   (reify Object
;     (createUrl [this token prefix location]
;       (str/join [prefix token]))
;     (retrieveToken [this prefix location]
;       (subs (.. js/window -location -pathname) (count prefix)))))

;; History ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; (def history (history-cell {:transformer transformer}))

; (def history! (partial reset! history))

; (j/cell= (prn "history" history))

; (defn- history-state []
;   (let [history (.-history js/window)
;         historyc (j/cell (.-state history))]
;     (j/with-let [_ (j/cell= historyc (fn [state] (.pushState history (clj->js state) (.-title js/document))))]
;       (events/listen js/window EventType.NAVIGATE
;         (fn [event] (reset! historyc (.-state event)))))))
;
; (def state (history-state))
;
; (j/cell= (.log js/console "state" state))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URL Search Params ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; (defn mksearch
;   ([] (mksearch (.. js/window -location -search)))
;   ([path] (prn path) (js/URLSearchParams. path)))
;
; (defn- search->clj [search]
;   (let [entries (.entries search)]
;     (js->clj (obj/from-entries entries))))
;
; (j/defc= search (search->clj (mksearch)) #(obj/set-in js/window [:location :search] (clj->js %)))
;
; (j/cell= (prn "search" search))
;
; (defn search-cell [key & [default]]
;   (j/cell= (or (.get search (name key) default)) #(reset! search (.set @search (name key) %))))
;
; (def search! (partial reset! search))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; App Route State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; (defn- path->kw [path]
;   (mapv keyword (remove empty? (str/split path "/"))))
;
; (defn- kw->path [& korks]
;   (str/join "/" (mapv name (flatten korks))))
;
;(j/defc= route (path->kw path) #(reset! path (kw->path %)))

;(j/cell= (prn "route" route))

; (defn router
;   ([routes] (router routes nil))
;   ([routes default] (j/cell= (pw/match-route routes path default))))

(defn route!
  ([path] (route! path nil))
  ([path query] (route! path query @state))
  ([path query state]
   (let [title  (.. js/document -title)
         state  (clj->js state)
         search (clj->search query)
         token  (if query (str/join "?" [path (str search)]) path)]
     (j/dosync
       (push! state title token)
       (popstate! state)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
