(ns degree9.routing
  (:require [goog.events :as events]
            [javelin.core :as j]
            [degree9.object :as obj]
            [degree9.string :as str])
  (:require-macros degree9.routing)
  (:import [goog.events EventType]))

;; Window History Object ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def ^:dynamic *history* (.-history js/window))

(j/cell= (.log js/console "*history*" *url*))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn- url-cell [loc]
  (let [url (j/cell (js/URL. loc))]
    (j/with-let [url= (j/cell= url (fn [loc] (reset! url (js/URL. loc))))]
      (events/listen js/window #js[EventType.POPSTATE EventType.HASHCHANGE]
        (fn [event] (reset! url (js/URL. (.-location js/window))))))))

(j/cell *url* (js/URL. (.-location js/window)))

(j/cell= (.log js/console "*url*" *url*))

(j/cell *search* (js/URLSearchParams. (.-search (.-location js/window))))

(j/cell= (.log js/console "*search*" *url*))

(j/cell *state* (.-state *history*))

(j/cell= (.log js/console "*state*" *state*))

(defn- push-history! [])

(defn- replace-history! [])

(defn mkhistory [{:keys [prefix fragment transformer]}]
   (if (Html5History.isSupported)
     (doto (Html5History. nil transformer)
       (.setPathPrefix  prefix)
       (.setUseFragment fragment))
     (History.)))

(defn history-cell [& [opts]]
  (let [history  (mkhistory opts)
        historyc (j/cell (.getToken history))]
   (j/with-let [_ (j/cell= historyc (fn [token] (.setToken history token)))]
     (events/listen history EventType.NAVIGATE
       (fn [event] (reset! historyc (.-token event))))
     (.setEnabled history true))))

(def transformer
  (reify Object
    (createUrl [this token prefix location]
      (str/join [prefix token]))
    (retrieveToken [this prefix location]
      (subs (.. js/window -location -pathname) (count prefix)))))

;; History ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def history (history-cell {:transformer transformer}))

(def history! (partial reset! history))

(j/cell= (prn "history" history))

; (defn- history-state []
;   (let [history (.-history js/window)
;         historyc (j/cell (.-state history))]
;     (j/with-let [_ (j/cell= historyc (fn [state] (.pushState history (clj->js state) (.-title js/document))))]
;       (events/listen js/window EventType.POPSTATE
;         (fn [event] (reset! historyc (.-state event)))))))
;
; (def state (history-state))
;
; (j/cell= (.log js/console "state" state))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URL Search Params ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn mksearch
  ([] (mksearch (.. js/window -location -search)))
  ([path] (prn path) (js/URLSearchParams. path)))

(defn- search->clj [search]
  (let [entries (.entries search)]
    (js->clj (obj/from-entries entries))))

(j/defc= search (search->clj (mksearch)) #(obj/set-in js/window [:location :search] (clj->js %)))

(j/cell= (prn "search" search))

(defn search-cell [key & [default]]
  (j/cell= (or (.get search (name key) default)) #(reset! search (.set @search (name key) %))))

(def search! (partial reset! search))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; App Route State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; (defn- path->kw [path]
;   (mapv keyword (remove empty? (str/split path "/"))))
;
; (defn- kw->path [& korks]
;   (str/join "/" (mapv name (flatten korks))))
;
;(j/defc= route (path->kw path) #(reset! path (kw->path %)))

;(j/cell= (prn "route" route))

; (defn router
;   ([routes] (router routes nil))
;   ([routes default] (j/cell= (pw/match-route routes path default))))

(defn route! [route & [query]]
  (j/dosync
    (history! route)
    (when query
      (search! query))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
