(ns degree9.routing
  (:require ;[goog.url :as url]
            [goog.events :as events]
            [goog.Uri :as uri]
            [goog.Uri.QueryData :as qd]
            [javelin.core :as j]
            [hoplon.history :as h]
            [degree9.string :as str])
            ;[degree9.pathway :as pw])
  (:require-macros degree9.routing)
  (:import [goog.events EventType]))

;; need to rewrite this with goog.url once closure library is updated

(defn- mkurl
  ([] (mkurl (.-location js/window)))
  ([url] (js/URL. url)))

(def ^:dynamic *url* (mkurl))

(defn- url-cell [& {:keys [url] :as opts}]
  (let [url (or url *url*)
        urlc (j/cell url)]
    (j/with-let [urlc= (j/cell= urlc (fn [url] (reset! urlc (mkurl url))))]
      (events/listen js/window EventType.HASHCHANGE
        (fn [event] (reset! urlc (.-location js/window)))))))

(def url (url-cell))

(j/cell= (.log js/console "url" url))

(defn history-path
 [& {:keys [history prefix fragment] :as opts}]
 (let [history  (or history h/*history*)
       historyc (j/cell history)];(.getToken history))]
  (j/with-let [_ (j/cell= historyc (fn [token] (.setToken history token)))]
   (events/listen history EventType.NAVIGATE
    (fn [event] (reset! historyc event))) ;(.-token event))))
   (.setEnabled history true))))

;; History State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def history (h/history-cell :prefix "/" :fragment false))

(def hp (history-path :prefix "/" :fragment false))

(j/cell= (prn "history" history "HP" hp))

(defn- history-state []
  (let [history (.-history js/window)
        historyc (j/cell (.-state history))]
    (j/with-let [_ (j/cell= historyc (fn [state] (.pushState history (clj->js state) (.-title js/document))))]
      (events/listen js/window EventType.POPSTATE
        (fn [event] (reset! historyc (.-state event)))))))

(def state (history-state))

(j/cell= (.log js/console "state" state))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URI State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(j/defc= uri (uri/parse history) #(reset! history (.toString %)))

(j/cell= (prn "uri" uri))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URI Path State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(j/defc= path (.getPath uri) #(reset! uri (.setPath @uri %)))

(j/cell= (prn "path" path))

(defn path! [p]
  (reset! path p))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URI Query State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn- clj->query [data]
  (qd/createFromMap (clj->js data)))

(j/defc= query (.getQueryData uri) #(reset! uri (.setQueryData @uri (clj->query %))))

(j/cell= (prn "query" query))

(defn query-cell [key & [default]]
  (j/cell= (.get query (name key) default) #(reset! query (.set @query (name key) %))))

(defn query! [q]
  (reset! query q))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; App Route State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn- path->kw [path]
  (mapv keyword (remove empty? (str/split path "/"))))

(defn- kw->path [& korks]
  (str/join "/" (mapv name (flatten korks))))

(j/defc= route (path->kw path) #(reset! path (kw->path %)))

(j/cell= (prn "route" route))

; (defn router
;   ([routes] (router routes nil))
;   ([routes default] (j/cell= (pw/match-route routes path default))))

(defn route!
  ([path] (route! path {}))
  ([path query] (route! path query @state))
  ([path query state]
   (let [title (.-title js/document)
         history (.-history js/window)]
     (j/dosync
       (.pushState history (clj->js state) title path)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
