(ns degree9.redis
  (:require ["redis" :as rs]
            [degree9.env :as env]
            [degree9.string :as s]))

(defn- redis-url [& {:keys [host port password]}]
  (s/join
    (cond-> ["rediss://"]
      password (conj (str ":" password "@"))
      host     (conj (str host))
      port     (conj (str ":" port)))))

(defn- mkclient [& [opts]]
  (.client rs (redis-url opts)))

(defn redis [& [opts]]
  (let [host     (env/require "REDISCACHEHOSTNAME")
        port     (env/require "REDISCACHEPORT")
        password (env/require "REDISCACHEKEY")
        client   (:client opts (mkclient {:host host :port port :password password}))]
    (debug "Initializing redis service.")
    (reify
      Object
      (find [this params])
      ;  (list-namespace api))
      (get [this id params])
      ;  (read-namespace api id))
      (create [this data params])
      ;  (create-namespace api data))
      (update [this id data params])
      ;  (replace-namespace api id data))
      (patch [this id data params])
      ;  (patch-namespace api id data))
      (remove [this id params]))))
      ;  (delete-namespace api id)))))

;; D9 Public Functions ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn connect! [& [opts]]
  (let [host     (env/require "REDISCACHEHOSTNAME")
        port     (env/require "REDISCACHEPORT")
        password (env/require "REDISCACHEKEY")]
    (mkclient
      (merge opts
        {:host host :port port :password password}))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
