(ns degree9.date
  (:require [degree9.object :as obj]
            [degree9.string :as dstr]))

;; In the future this should be replaced with js/Temporal as the internals

(defprotocol Date
  "A Date protocol."
  (year  [this] "Get this year ")
  (month [this])
  (day   [this]))

(extend-type js/Date
  Date
  (year  [this] (.getFullYear this))
  (month [this] (-> (.getMonth this)
                    (dstr/pad-start 2 "0")
                    (inc)))
  (day   [this] (-> (.getDay this)
                    (dstr/pad-start 2 "0"))))
