(ns degree9.date
  (:require [degree9.object :as obj]
            [degree9.string :as dstr]))

;; In the future this should be replaced with js/Temporal as the internals

(defprotocol Date
  "A Date protocol."
  (year  [this])
  (month [this])
  (day   [this]))

(extend-type js/Date
  Date
  (year  [this] (obj/get this :year))
  (month [this] (dstr/pad-start (obj/get this :month) 2 0))
  (day   [this] (obj/get this :day)))
