(ns degree9.security
 (:require
   [degree9.debug :as dbg]
   [degree9.object :as obj]
   [feathers.application :as feathers]
   [feathers.errors :as error]
   [feathers.authentication :as auth]))

(dbg/defdebug debug "degree9:enterprise:security")

(defn authenticate [& [{:keys [strategies service] :or {strategies ["jwt"] service "/authentication"}}]]
  (fn [{:keys [app params type path] :as context}]
    (let [{:keys [authentication provider query]} params]
      (debug "Running authentication on %s" path)
      (if (obj/get params :authenticated) context
        (if-not authentication (throw (error/not-authenticated "Not Authenticated."))
          (let [params (obj/dissoc params :provider :authentication)]
            (debug "Authenticating with" authentication strategies)
            (-> (.service app service)
                (.authenticate authentication params))))))))

(defn secure-services
 "Takes a feathers app and adds a hook to enforce a valid JWT on every endpoint"
 [app]
 (debug "Secure all app endpoints with JWT")
 (feathers/hooks app
   (clj->js {:before {:all [(auth/authenticate #js{:service "/authentication" :strategies ["jwt"]})]}})))

(defn with-security [app]
  (debug "Loading server security api")
  (-> app
    (secure-services)))

(defn hook-context->jwt
 "Extracts JWT from hook context. Will only work after secure-services hook."
 [context]
 (some-> (js->clj context :keywordize-keys true)
  :params
  :accessToken))
