(ns degree9.auth.api-key
  (:require [degree9.debug :as dbg]
            [degree9.object :as obj]
            [degree9.es6 :as es6]
            [clojure.string :as cstr]
            ["@feathersjs/authentication" :as auth]))


(dbg/defdebug debug "degree9:enterprise:auth:api-key")

(def ^:private BaseStrategy (obj/get auth "AuthenticationBaseStrategy"))

(es6/defclass APIKeyStrategy BaseStrategy
  (constructor [app]
    (debug "Initialize APIKeyStrategy")
    (es6/super app))
  (configuration []
    (es6/super-as super
      (.log js/console super)
      (let [sconf (obj/get super :configuration)]
        (this-as this
          (let [{:keys [entity service]} (obj/get-in this [:authentication :configuration])]
            (-> {:entity entity :service service :header "x-api-key" :schemes ["API"]}
                (merge sconf)
                (clj->js)))))))
  (parse [req]
    (this-as this
      (let [conf    (.configuration this)]
            ;header  (obj/get conf :header)
            ;schemes (obj/get conf :schemes)]
        (.log js/console this)
        (.log js/console conf)))))
        ;(debug "Checking for request header %s" header)
        ;(prn header schemes)
        ; (when-let [header (obj/get-in req [:headers header])]
        ;   (debug "Request header contains %s" header)
        ;   (let [[scheme value] (cstr/split header #" " 2)]
        ;     (when (some #{scheme} schemes)
        ;       (prn this)
        ;       (clj->js {:strategy nil ;(obj/get this :name)
        ;                 :api-key value}))))))))

; (def APIKeyStrategy
;   (es6/class APIKeyStrategy BaseStrategy
;     (constructor [opts]
;       (prn "APIKeyStrategy" opts)
;       (es6/super (clj->js opts)))
;     (authenticate [data params]
;       (prn "APIKeyStrategy AUTHENTICATE" data params)
;       (.authenticate (es6/super) data params))))

; (extend-type APIKeyStrategy
;   FeathersAuthentication
;   (authenticate [this data params]
;     (prn "APIKeyStrategy AUTHENTICATE" data params)))
    ; (when-let [api-key (obj/get-in this [:configuration :api-key-header])]
    ;   (let [result (.findEntity this api-key (obj/dissoc params :provider))]
    ;     (clj->js {:authentication {:strategy (obj/get this :name)}
    ;               :api-key (.getEntity this result params)})))))

; (set! (.. oauth/OAuthStrategy -prototype -getProfile)
;   (fn [data & args]
;     (debug "getProfile raw data " data)
;     (-> data
;       (obj/get "id_token")
;       (obj/get "payload"))))
;
; (set! (.. oauth/OAuthStrategy -prototype -getEntityData)
;   (fn [data & args]
;     (debug "getEntityData raw data " data)
;     #js{:email (first (obj/get data "emails"))}))
;
; (set! (.. oauth/OAuthStrategy -prototype -getEntityQuery)
;   (fn [data & args]
;     (debug "getEntityQuery raw data " data)
;     #js{:email (first (obj/get data "emails"))}))

(defn with-api-key [app & opts]
  (let [auth (.service app "/authentication")
        svc  (APIKeyStrategy. app)]
    (debug "Registering API Key auth strategy.")
    (.register auth "api-key" svc)
    app))
