(ns degree9.auth.api-key
  (:require [degree9.debug :as dbg]
            [degree9.object :as obj]
            [degree9.es6 :as es6]
            ["@feathersjs/authentication" :as auth]))


(dbg/defdebug debug "degree9:enterprise:auth:api-key")

(def ^:private BaseStrategy (obj/get auth "AuthenticationBaseStrategy"))

; (es6/defclass APIKeyStrategy [opts] :extends BaseStrategy
;     (prn "APIKeyStrategy" opts)
;     (es6/super))

(def APIKeyStrategy
  (es6/class APIKeyStrategy BaseStrategy
    (constructor [this opts]
      (prn "APIKeyStrategy" opts)
      (es6/super (clj->js opts)))))

; (es6/defclass APIKeyStrategy2 [this & opts]
;   (prn "APIKeyStrategy2" opts)
;   (es6/super (clj->js opts)))


; (def APIKeyStrategy
;   (es6/class APIKeyStrategy BaseStrategy
;     (constructor [opts]
;       (prn "APIKeyStrategy" opts)
;       (es6/super (clj->js opts)))
;     (authenticate [data params]
;       (prn "APIKeyStrategy AUTHENTICATE" data params)
;       (.authenticate (es6/super) data params))))
    ; (parse [this req]
    ;   ;(this-as this
    ;     (let [conf   (obj/get-in this [:configuration :header])
    ;           header (obj/get-in req [:headers])]
    ;       (prn "APIKeyStrategy PARSE" conf req)))))

(extend-type APIKeyStrategy
  Object
  (parse [this req]
    (prn "EXTEND-TYPE PARSE")))

; (defprotocol FeathersAuthentication
;   (authenticate [this data params]))
;
; (extend-type APIKeyStrategy
;   FeathersAuthentication
;   (authenticate [this data params]
;     (prn "APIKeyStrategy AUTHENTICATE" data params)))
    ; (when-let [api-key (obj/get-in this [:configuration :api-key-header])]
    ;   (let [result (.findEntity this api-key (obj/dissoc params :provider))]
    ;     (clj->js {:authentication {:strategy (obj/get this :name)}
    ;               :api-key (.getEntity this result params)})))))

; (set! (.. oauth/OAuthStrategy -prototype -getProfile)
;   (fn [data & args]
;     (debug "getProfile raw data " data)
;     (-> data
;       (obj/get "id_token")
;       (obj/get "payload"))))
;
; (set! (.. oauth/OAuthStrategy -prototype -getEntityData)
;   (fn [data & args]
;     (debug "getEntityData raw data " data)
;     #js{:email (first (obj/get data "emails"))}))
;
; (set! (.. oauth/OAuthStrategy -prototype -getEntityQuery)
;   (fn [data & args]
;     (debug "getEntityQuery raw data " data)
;     #js{:email (first (obj/get data "emails"))}))

(defn with-api-key [app & opts]
  (let [auth (.service app "/authentication")
        svc  (APIKeyStrategy.)]
    (debug "Registering API Key auth strategy.")
    (.register auth "api-key" svc)
    app))
